/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ExposedByteArrayOutputStream;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;

class FilePersistenceUtils {
    FilePersistenceUtils() {
    }

    static File createTempFile(File fileName) {
        return new File(fileName.getParentFile(), fileName.getName() + ".tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExposedByteArrayOutputStream marshalXml(AbstractConfigurationPersister persister, ModelNode model) throws ConfigurationPersistenceException {
        ExposedByteArrayOutputStream marshalled = new ExposedByteArrayOutputStream(8192);
        try {
            try {
                BufferedOutputStream output = new BufferedOutputStream(marshalled);
                persister.marshallAsXml(model, output);
                output.close();
                marshalled.close();
            }
            finally {
                IoUtils.safeClose((Closeable)marshalled);
            }
        }
        catch (Exception e) {
            throw ControllerMessages.MESSAGES.failedToMarshalConfiguration(e);
        }
        return marshalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyFile(File file, File backup) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            FileOutputStream fos = new FileOutputStream(backup);
            try {
                StreamUtils.copyStream((InputStream)fis, (OutputStream)fos);
                fos.flush();
                fos.getFD().sync();
                fos.close();
            }
            finally {
                StreamUtils.safeClose((Closeable)fos);
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)fis);
        }
    }

    static void rename(File file, File to) throws IOException {
        if (!file.renameTo(to) && file.exists()) {
            FilePersistenceUtils.copyFile(file, to);
        }
    }

    static void moveTempFileToMain(File tempFileName, File fileName) throws ConfigurationPersistenceException {
        try {
            FilePersistenceUtils.rename(tempFileName, fileName);
            FilePersistenceUtils.deleteFile(tempFileName);
        }
        catch (Exception e) {
            throw ControllerMessages.MESSAGES.failedToRenameTempFile(e, tempFileName, fileName);
        }
    }

    static void deleteFile(File file) {
        if (file.exists() && !file.delete() && file.exists()) {
            file.deleteOnExit();
            throw new IllegalStateException(ControllerMessages.MESSAGES.couldNotDeleteFile(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File writeToTempFile(ExposedByteArrayOutputStream marshalled, File tempFileName) throws IOException {
        FilePersistenceUtils.deleteFile(tempFileName);
        FileOutputStream fos = new FileOutputStream(tempFileName);
        ByteArrayInputStream is = marshalled.getInputStream();
        try {
            int read;
            BufferedOutputStream output = new BufferedOutputStream(fos);
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) > -1) {
                output.write(bytes, 0, read);
            }
            output.flush();
            fos.getFD().sync();
            output.close();
            ((InputStream)is).close();
        }
        finally {
            IoUtils.safeClose((Closeable)fos);
            IoUtils.safeClose((Closeable)is);
        }
        return tempFileName;
    }
}

