/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.List;
import org.jboss.as.clustering.jgroups.JGroupsMessages;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResource;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class ProtocolLayerRemove
implements OperationStepHandler {
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        ModelNode type = ProtocolResource.TYPE.validateOperation(operation);
        PathElement protocolRelativePath = PathElement.pathElement((String)"protocol", (String)type.asString());
        if (!resource.hasChild(protocolRelativePath)) {
            throw JGroupsMessages.MESSAGES.protocolNotDefined(protocolRelativePath.toString());
        }
        context.removeResource(PathAddress.pathAddress((PathElement[])new PathElement[]{protocolRelativePath}));
        List protocols = subModel.get("protocols").asList();
        ModelNode newList = new ModelNode();
        if (protocols == null) {
            // empty if block
        }
        for (ModelNode protocol : protocols) {
            if (protocol.asString().equals(type.asString())) continue;
            newList.add(protocol);
        }
        subModel.get("protocols").set(newList);
        this.reloadRequiredStep(context);
        context.stepCompleted();
    }

    void reloadRequiredStep(OperationContext context) {
        if (context.getProcessType().isServer() && !context.isBooting()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

