/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;

public class CacheContainerReadAttributeHandler
implements OperationStepHandler {
    public static final CacheContainerReadAttributeHandler INSTANCE = new CacheContainerReadAttributeHandler();
    private final ParametersValidator nameValidator = new ParametersValidator();
    private final Map<String, AttributeDefinition> attributeDefinitions;

    private CacheContainerReadAttributeHandler() {
        this(CacheContainerResource.CACHE_CONTAINER_ATTRIBUTES);
    }

    private CacheContainerReadAttributeHandler(AttributeDefinition ... definitions) {
        assert (definitions != null) : ControllerMessages.MESSAGES.nullVar("definitions").getLocalizedMessage();
        this.nameValidator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
        this.attributeDefinitions = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition def : definitions) {
            this.attributeDefinitions.put(def.getName(), def);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.nameValidator.validate(operation);
        String attributeName = operation.require("name").asString();
        ModelNode submodel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode currentValue = submodel.get(attributeName).clone();
        context.getResult().set(currentValue);
        context.stepCompleted();
    }
}

