/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.view;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Component;

@Component(value="messageSource")
public class CasReloadableMessageBundle
extends ReloadableResourceBundleMessageSource {
    private String[] basenames;
    private final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected String getDefaultMessage(String code) {
        String messageToReturn = super.getDefaultMessage(code);
        if (!StringUtils.isBlank((CharSequence)messageToReturn) && messageToReturn.equals(code)) {
            this.logger.warn("The code [{}] cannot be found in the default language bundle and will be used as the message itself.", (Object)code);
        }
        return messageToReturn;
    }

    protected String getMessageInternal(String code, Object[] args, Locale locale) {
        boolean foundCode = false;
        if (!locale.equals(Locale.ENGLISH)) {
            int i = 0;
            while (!foundCode && i < this.basenames.length) {
                String filename = String.valueOf(this.basenames[i]) + '_' + locale;
                this.logger.debug("Examining language bundle [{}] for the code [{}]", (Object)filename, (Object)code);
                ReloadableResourceBundleMessageSource.PropertiesHolder holder = this.getProperties(filename);
                foundCode = holder != null && holder.getProperties() != null && holder.getProperty(code) != null;
                ++i;
            }
            if (!foundCode) {
                this.logger.debug("The code [{}] cannot be found in the language bundle for the locale [{}]", (Object)code, (Object)locale);
            }
        }
        return super.getMessageInternal(code, args, locale);
    }

    @Autowired
    public void setBasenames(String ... basenames) {
        this.basenames = basenames;
        super.setBasenames(basenames);
    }

    @Autowired
    public void setDefaultEncoding(@Value(value="${message.bundle.encoding:UTF-8}") String defaultEncoding) {
        super.setDefaultEncoding(defaultEncoding);
    }

    @Autowired
    public void setCacheSeconds(@Value(value="${message.bundle.cacheseconds:180}") int cacheSeconds) {
        super.setCacheSeconds(cacheSeconds);
    }

    @Autowired
    public void setFallbackToSystemLocale(@Value(value="${message.bundle.fallback.systemlocale:false}") boolean fallbackToSystemLocale) {
        super.setFallbackToSystemLocale(fallbackToSystemLocale);
    }

    @Autowired
    public void setUseCodeAsDefaultMessage(@Value(value="${message.bundle.usecode.message:true}") boolean useCodeAsDefaultMessage) {
        super.setUseCodeAsDefaultMessage(useCodeAsDefaultMessage);
    }
}

