/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.authentication.principal.ServiceFactory;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArgumentExtractor
implements ArgumentExtractor {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="serviceFactoryList")
    protected List<ServiceFactory<? extends WebApplicationService>> serviceFactoryList = new ArrayList<ServiceFactory<? extends WebApplicationService>>();

    public AbstractArgumentExtractor() {
    }

    public AbstractArgumentExtractor(ServiceFactory<? extends WebApplicationService> serviceFactory) {
        this.serviceFactoryList.add(serviceFactory);
    }

    public AbstractArgumentExtractor(List<ServiceFactory<? extends WebApplicationService>> serviceFactoryList) {
        this.serviceFactoryList.addAll(serviceFactoryList);
    }

    public final WebApplicationService extractService(HttpServletRequest request) {
        WebApplicationService service = this.extractServiceInternal(request);
        if (service == null) {
            this.logger.debug("Extractor did not generate service.");
        } else {
            this.logger.debug("Extractor generated service for: {}", (Object)service.getId());
        }
        return service;
    }

    protected abstract WebApplicationService extractServiceInternal(HttpServletRequest var1);

    public final ServiceFactory<? extends WebApplicationService> getServiceFactory() {
        return this.serviceFactoryList.get(0);
    }

    protected final List<ServiceFactory<? extends WebApplicationService>> getServiceFactories() {
        return this.serviceFactoryList;
    }
}

