/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.client;

import java.util.List;
import java.util.Objects;
import org.dromara.mica.mqtt.codec.MqttMessage;
import org.dromara.mica.mqtt.codec.MqttSubscribeMessage;
import org.dromara.mica.mqtt.core.client.MqttClientSubscription;
import org.dromara.mica.mqtt.core.common.RetryProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.utils.timer.TimerTaskService;

final class MqttPendingSubscription {
    private static final Logger logger = LoggerFactory.getLogger(MqttPendingSubscription.class);
    private final List<MqttClientSubscription> subscriptionList;
    private final RetryProcessor<MqttSubscribeMessage> retryProcessor = new RetryProcessor();

    MqttPendingSubscription(List<MqttClientSubscription> subscriptionList, MqttSubscribeMessage message) {
        this.subscriptionList = subscriptionList;
        this.retryProcessor.setOriginalMessage((MqttMessage)message);
    }

    public List<MqttClientSubscription> getSubscriptionList() {
        return this.subscriptionList;
    }

    void startRetransmitTimer(TimerTaskService taskService, ChannelContext context) {
        this.retryProcessor.setHandle((fixedHeader, originalMessage) -> {
            boolean result = Tio.send((ChannelContext)context, (Packet)new MqttSubscribeMessage(fixedHeader, originalMessage.variableHeader(), originalMessage.payload()));
            logger.info("retry send Subscribe topics:{} result:{}", this.subscriptionList, (Object)result);
        });
        this.retryProcessor.start(taskService);
    }

    void onSubAckReceived() {
        this.retryProcessor.stop();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttPendingSubscription that = (MqttPendingSubscription)o;
        return Objects.equals(this.subscriptionList, that.subscriptionList);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionList);
    }
}

