/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class HAUtilClient {
    public static boolean isLogicalUri(Configuration conf, URI nameNodeUri) {
        String host = nameNodeUri.getHost();
        return DFSUtilClient.getNameServiceIds(conf).contains(host);
    }

    public static boolean isClientFailoverConfigured(Configuration conf, URI nameNodeUri) {
        String host = nameNodeUri.getHost();
        String configKey = "dfs.client.failover.proxy.provider." + host;
        return conf.get(configKey) != null;
    }

    public static Text buildTokenServiceForLogicalUri(URI uri, String scheme) {
        return new Text(HAUtilClient.buildTokenServicePrefixForLogicalUri(scheme) + uri.getHost());
    }

    public static String buildTokenServicePrefixForLogicalUri(String scheme) {
        return "ha-" + scheme + ":";
    }

    public static URI getServiceUriFromToken(String scheme, Token<?> token) {
        String prefix;
        String tokStr = token.getService().toString();
        if (tokStr.startsWith(prefix = HAUtilClient.buildTokenServicePrefixForLogicalUri(scheme))) {
            tokStr = tokStr.replaceFirst(prefix, "");
        }
        return URI.create(scheme + "://" + tokStr);
    }

    public static boolean isTokenForLogicalUri(Token<?> token) {
        return token.getService().toString().startsWith("ha-");
    }
}

