/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server.cluster.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ReconnConf;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.Tio;
import org.tio.core.uuid.SnowflakeTioUuid;
import org.tio.server.TioServer;
import org.tio.server.TioServerConfig;
import org.tio.server.cluster.codec.ClusterMessageDecoder;
import org.tio.server.cluster.core.ClusterApi;
import org.tio.server.cluster.core.ClusterConfig;
import org.tio.server.cluster.core.ClusterMessageListener;
import org.tio.server.cluster.core.ClusterTcpClientHandler;
import org.tio.server.cluster.core.ClusterTcpClientListener;
import org.tio.server.cluster.core.ClusterTcpServerHandler;
import org.tio.server.cluster.core.ClusterTcpServerListener;
import org.tio.server.cluster.message.ClusterDataMessage;
import org.tio.server.cluster.message.ClusterSyncAckMessage;
import org.tio.server.cluster.message.ClusterSyncMessage;
import org.tio.utils.hutool.Snowflake;
import org.tio.utils.thread.ThreadUtils;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;
import org.tio.utils.timer.TimerTask;

public class ClusterImpl
implements ClusterApi {
    private static final Logger log = LoggerFactory.getLogger(ClusterImpl.class);
    private final ClusterConfig config;
    private final Node localMember;
    private final List<Node> seedMembers;
    private final List<Node> lateJoinMembers;
    private TioServer tcpClusterServer;
    private TioClient tcpClusterClient;
    private final ClusterMessageDecoder messageDecoder;
    private final ConcurrentMap<Long, CompletableFuture<ClusterSyncAckMessage>> syncMessageMap;
    private final Snowflake snowflake;

    public ClusterImpl(ClusterConfig config) {
        this.config = config;
        this.localMember = new Node(config.getHost(), config.getPort());
        this.seedMembers = ClusterImpl.filterSeedMembers(config);
        this.lateJoinMembers = new ArrayList<Node>();
        this.messageDecoder = new ClusterMessageDecoder();
        this.syncMessageMap = new ConcurrentHashMap<Long, CompletableFuture<ClusterSyncAckMessage>>();
        this.snowflake = new Snowflake((long)ThreadLocalRandom.current().nextInt(1, 30), (long)ThreadLocalRandom.current().nextInt(1, 30));
    }

    private static List<Node> filterSeedMembers(ClusterConfig config) {
        return config.getSeedMembers().stream().distinct().collect(Collectors.toList());
    }

    @Override
    public void start() throws Exception {
        this.startClusterTcpService();
        this.startClusterTcpClient();
    }

    private void startClusterTcpService() throws IOException {
        ClusterMessageListener messageListener = this.config.getMessageListener();
        ClusterTcpServerHandler serverHandler = new ClusterTcpServerHandler(this, this.messageDecoder, messageListener);
        String name = "TCP-cluster-server";
        int tioPoolSize = ThreadUtils.AVAILABLE_PROCESSORS + 1;
        SynThreadPoolExecutor tioExecutor = ThreadUtils.getTioExecutor((int)tioPoolSize);
        ExecutorService groupExecutor = ThreadUtils.getGroupExecutor((int)(tioPoolSize * 2));
        TioServerConfig serverConfig = new TioServerConfig(name, serverHandler, new ClusterTcpServerListener(), tioExecutor, groupExecutor);
        this.tcpClusterServer = new TioServer(serverConfig);
        this.tcpClusterServer.start("0.0.0.0", this.config.getPort());
    }

    private void startClusterTcpClient() throws Exception {
        ClusterTcpClientHandler tioHandler = new ClusterTcpClientHandler(this.messageDecoder, this.syncMessageMap);
        ClusterTcpClientListener tioListener = new ClusterTcpClientListener(this);
        TioClientConfig clientConfig = new TioClientConfig(tioHandler, tioListener);
        clientConfig.setName("TCP-cluster-client");
        clientConfig.setReconnConf(new ReconnConf(1000L));
        clientConfig.setTioUuid(new SnowflakeTioUuid());
        this.tcpClusterClient = new TioClient(clientConfig);
        ArrayList<Node> clientNodes = new ArrayList<Node>(this.seedMembers);
        clientNodes.remove(this.localMember);
        for (Node seedMember : clientNodes) {
            this.tcpClusterClient.connect(seedMember);
        }
    }

    @Override
    public void stop() {
        this.tcpClusterClient.stop();
        this.tcpClusterServer.stop();
    }

    @Override
    public boolean send(Node address, byte[] data) {
        TioClientConfig clientConfig = this.tcpClusterClient.getClientConfig();
        ChannelContext context = Tio.getByClientNode(clientConfig, address);
        return Tio.send(context, new ClusterDataMessage(data));
    }

    @Override
    public ClusterSyncAckMessage sendSync(Node address, byte[] message) {
        TioClientConfig clientConfig = this.tcpClusterClient.getClientConfig();
        ChannelContext context = Tio.getByClientNode(clientConfig, address);
        long messageId = this.snowflake.nextId();
        CompletableFuture future = new CompletableFuture();
        this.syncMessageMap.put(messageId, future);
        Tio.send(context, new ClusterSyncMessage(messageId, message));
        return (ClusterSyncAckMessage)future.join();
    }

    @Override
    public void broadcast(byte[] data) {
        TioClientConfig clientConfig = this.tcpClusterClient.getClientConfig();
        Set<ChannelContext> contextSet = Tio.getConnecteds(clientConfig);
        Tio.sendToSet(clientConfig, contextSet, new ClusterDataMessage(data), null);
    }

    @Override
    public TimerTask schedule(Runnable command, long delay) {
        return this.tcpClusterClient.schedule(command, delay);
    }

    @Override
    public TimerTask schedule(Runnable command, long delay, Executor executor) {
        return this.tcpClusterClient.schedule(command, delay, executor);
    }

    @Override
    public TimerTask scheduleOnce(Runnable command, long delay) {
        return this.tcpClusterClient.scheduleOnce(command, delay);
    }

    @Override
    public TimerTask scheduleOnce(Runnable command, long delay, Executor executor) {
        return this.tcpClusterClient.scheduleOnce(command, delay, executor);
    }

    @Override
    public boolean isLateJoinMember() {
        return !this.config.getSeedMembers().contains(this.localMember);
    }

    @Override
    public Collection<Node> getSeedMembers() {
        return Collections.unmodifiableList(this.config.getSeedMembers());
    }

    @Override
    public Collection<Node> getRemoteMembers() {
        HashSet<Node> remoteMembers = new HashSet<Node>(this.seedMembers);
        remoteMembers.addAll(this.lateJoinMembers);
        remoteMembers.remove(this.localMember);
        return Collections.unmodifiableSet(remoteMembers);
    }

    @Override
    public Node getLocalMember() {
        return this.localMember;
    }

    protected synchronized void addJoinMember(Node joinMember) {
        if (!this.lateJoinMembers.contains(joinMember)) {
            this.lateJoinMembers.add(joinMember);
            try {
                this.tcpClusterClient.connect(joinMember);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

