/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server.cluster.codec;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.tio.core.Node;
import org.tio.server.cluster.message.AbsClusterMessage;
import org.tio.server.cluster.message.ClusterDataMessage;
import org.tio.server.cluster.message.ClusterJoinMessage;
import org.tio.server.cluster.message.ClusterMessageType;
import org.tio.server.cluster.message.ClusterSyncAckMessage;
import org.tio.server.cluster.message.ClusterSyncMessage;
import org.tio.utils.buffer.ByteBufferUtil;

public class ClusterMessageEncoder {
    public static final ClusterMessageEncoder INSTANCE = new ClusterMessageEncoder();

    private ClusterMessageEncoder() {
    }

    public ByteBuffer encode(AbsClusterMessage message) {
        ClusterMessageType messageType = message.getMessageType();
        switch (messageType) {
            case PING: 
            case PONG: {
                return ClusterMessageEncoder.encodePingPongMessage(messageType);
            }
            case DATA: {
                return ClusterMessageEncoder.encodeDataMessage((ClusterDataMessage)message);
            }
            case SYNC: {
                return ClusterMessageEncoder.encodeSyncMessage((ClusterSyncMessage)message);
            }
            case SYNC_ACK: {
                return ClusterMessageEncoder.encodeSyncAckMessage((ClusterSyncAckMessage)message);
            }
            case JOIN: {
                return ClusterMessageEncoder.encodeJoinMessage((ClusterJoinMessage)message);
            }
        }
        throw new IllegalArgumentException("\u5c55\u793a\u4e0d\u652f\u6301\u8be5\u96c6\u7fa4\u6d88\u606f\u7c7b\u578b");
    }

    private static ByteBuffer encodePingPongMessage(ClusterMessageType messageType) {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put(messageType.getType());
        return buffer;
    }

    private static ByteBuffer encodeDataMessage(ClusterDataMessage message) {
        byte[] payload = message.getPayload();
        int dataLength = payload.length;
        int dataLengthLength = ClusterMessageEncoder.getVariableLengthInt(dataLength);
        ByteBuffer buffer = ByteBuffer.allocate(1 + dataLengthLength + dataLength);
        buffer.put(ClusterMessageType.DATA.getType());
        ClusterMessageEncoder.writeVariableLengthInt(buffer, dataLength);
        buffer.put(payload);
        return buffer;
    }

    private static ByteBuffer encodeSyncMessage(ClusterSyncMessage message) {
        byte[] payload = message.getPayload();
        int dataLength = payload.length;
        int dataLengthLength = ClusterMessageEncoder.getVariableLengthInt(dataLength);
        int capacity = 9 + dataLengthLength + dataLength;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(ClusterMessageType.SYNC.getType());
        long messageId = message.getMessageId();
        buffer.putLong(messageId);
        ClusterMessageEncoder.writeVariableLengthInt(buffer, dataLength);
        buffer.put(payload);
        return buffer;
    }

    private static ByteBuffer encodeSyncAckMessage(ClusterSyncAckMessage message) {
        int capacity = 9;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(ClusterMessageType.SYNC_ACK.getType());
        buffer.putLong(message.getMessageId());
        return buffer;
    }

    private static ByteBuffer encodeJoinMessage(ClusterJoinMessage message) {
        int capacity = 35;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(ClusterMessageType.JOIN.getType());
        Node joinMember = message.getJoinMember();
        ByteBufferUtil.writeShortLE((ByteBuffer)buffer, (int)joinMember.getPort());
        buffer.put(joinMember.getIp().getBytes(StandardCharsets.UTF_8));
        buffer.position(capacity);
        return buffer;
    }

    private static int getVariableLengthInt(int num) {
        int count = 0;
        do {
            ++count;
        } while ((num /= 128) > 0);
        return count;
    }

    private static void writeVariableLengthInt(ByteBuffer buf, int num) {
        do {
            int digit = num % 128;
            if ((num /= 128) > 0) {
                digit |= 0x80;
            }
            buf.put((byte)digit);
        } while (num > 0);
    }
}

