/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl;

import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.tio.core.ssl.ClientAuth;
import org.tio.core.ssl.SSLEngineCustomizer;
import org.tio.utils.hutool.ResourceUtil;
import org.tio.utils.hutool.StrUtil;

public class SslConfig {
    private static final String ALGORITHM = "SunX509";
    private final ClientAuth clientAuth;
    private final KeyManager[] kms;
    private final TrustManager[] tms;
    private SSLEngineCustomizer sslEngineCustomizer;

    public SslConfig(KeyManager[] kms, TrustManager[] tms) {
        this(ClientAuth.NONE, kms, tms);
    }

    public SslConfig(ClientAuth clientAuth, KeyManager[] kms, TrustManager[] tms) {
        this.clientAuth = clientAuth;
        this.kms = kms;
        this.tms = tms;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public SSLContext getSslContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(this.kms, this.tms, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public SSLEngineCustomizer getSslEngineCustomizer() {
        return this.sslEngineCustomizer;
    }

    public void setSslEngineCustomizer(SSLEngineCustomizer sslEngineCustomizer) {
        this.sslEngineCustomizer = sslEngineCustomizer;
    }

    public static SslConfig forServer(String keyStoreFile, String keyPasswd) {
        return SslConfig.forServer(keyStoreFile, keyPasswd, ClientAuth.NONE);
    }

    public static SslConfig forServer(String keyStoreFile, String keyPasswd, ClientAuth clientAuth) {
        return SslConfig.forServer(keyStoreFile, keyPasswd, null, null, clientAuth);
    }

    public static SslConfig forServer(String keyStoreFile, String keyPasswd, String trustStoreFile, String trustPassword, ClientAuth clientAuth) {
        KeyManager[] kms = SslConfig.getKeyManager(keyStoreFile, keyPasswd);
        TrustManager[] tms = SslConfig.getTrustManager(trustStoreFile, trustPassword);
        return new SslConfig(clientAuth, kms, tms);
    }

    public static SslConfig forServer(InputStream keyStoreInputStream, String keyPasswd) {
        return SslConfig.forServer(keyStoreInputStream, keyPasswd, ClientAuth.NONE);
    }

    public static SslConfig forServer(InputStream keyStoreInputStream, String keyPasswd, ClientAuth clientAuth) {
        return SslConfig.forServer(keyStoreInputStream, keyPasswd, null, null, clientAuth);
    }

    public static SslConfig forServer(InputStream keyStoreInputStream, String keyPasswd, InputStream trustStoreInputStream, String trustPassword, ClientAuth clientAuth) {
        KeyManager[] kms = SslConfig.getKeyManager(keyStoreInputStream, keyPasswd);
        TrustManager[] tms = SslConfig.getTrustManager(trustStoreInputStream, trustPassword);
        return new SslConfig(clientAuth, kms, tms);
    }

    public static SslConfig forClient() {
        return SslConfig.forClient((InputStream)null, null);
    }

    public static SslConfig forClient(String trustStoreFile, String trustPassword) {
        return SslConfig.forClient(null, null, trustStoreFile, trustPassword);
    }

    public static SslConfig forClient(String keyStoreFile, String keyPasswd, String trustStoreFile, String trustPassword) {
        KeyManager[] kms = SslConfig.getKeyManager(keyStoreFile, keyPasswd);
        TrustManager[] tms = SslConfig.getTrustManager(trustStoreFile, trustPassword);
        return new SslConfig(kms, tms);
    }

    public static SslConfig forClient(InputStream trustStoreInputStream, String trustPassword) {
        return SslConfig.forClient(null, null, trustStoreInputStream, trustPassword);
    }

    public static SslConfig forClient(InputStream keyStoreInputStream, String keyPasswd, InputStream trustStoreInputStream, String trustPassword) {
        KeyManager[] kms = SslConfig.getKeyManager(keyStoreInputStream, keyPasswd);
        TrustManager[] tms = SslConfig.getTrustManager(trustStoreInputStream, trustPassword);
        return new SslConfig(kms, tms);
    }

    public static KeyManager[] getKeyManager(String keyStoreFile, String keyPass) {
        InputStream keyStoreInputStream = keyStoreFile == null ? null : (StrUtil.startWithIgnoreCase((CharSequence)keyStoreFile, (CharSequence)"classpath:") ? ResourceUtil.getResourceAsStream((String)keyStoreFile) : ResourceUtil.getFileResource((String)keyStoreFile));
        return SslConfig.getKeyManager(keyStoreInputStream, keyPass);
    }

    public static KeyManager[] getKeyManager(InputStream keyStoreInputStream, String keyPass) {
        if (keyStoreInputStream != null) {
            try {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(ALGORITHM);
                KeyStore keyStore = KeyStore.getInstance("JKS");
                char[] keyPassChars = keyPass == null ? null : keyPass.toCharArray();
                keyStore.load(keyStoreInputStream, keyPassChars);
                keyManagerFactory.init(keyStore, keyPassChars);
                return keyManagerFactory.getKeyManagers();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public static TrustManager[] getTrustManager(String trustStoreFile, String trustPass) {
        InputStream trustStoreInputStream = trustStoreFile == null ? null : (StrUtil.startWithIgnoreCase((CharSequence)trustStoreFile, (CharSequence)"classpath:") ? ResourceUtil.getResourceAsStream((String)trustStoreFile) : ResourceUtil.getFileResource((String)trustStoreFile));
        return SslConfig.getTrustManager(trustStoreInputStream, trustPass);
    }

    public static TrustManager[] getTrustManager(InputStream trustInputStream, String trustPass) {
        if (trustInputStream != null) {
            char[] trustPassChars = trustPass == null ? null : trustPass.toCharArray();
            try {
                return SslConfig.getTrustManagers(trustInputStream, trustPassChars);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    private static TrustManager[] getTrustManagers(InputStream trustInputStream, char[] trustPassword) throws Exception {
        if (trustInputStream == null) {
            return new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(ALGORITHM);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(trustInputStream, trustPassword);
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }
}

