/*
 * Decompiled with CFR 0.152.
 */
package io.github.whitedg.mybatis.crypto;

import io.github.whitedg.mybatis.crypto.IEncryptor;
import io.github.whitedg.mybatis.crypto.MybatisCryptoConfig;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="mybatis-crypto")
public class MybatisCryptoProperties {
    private boolean enabled = true;
    private List<String> mappedKeyPrefixes;
    private boolean failFast = true;
    private String defaultKey;
    private Class<? extends IEncryptor> defaultEncryptor;
    private String typePackages;
    private boolean keepParameter;
    private MybatisCryptoConfig mybatisCryptoConfig;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Class<? extends IEncryptor> getDefaultEncryptor() {
        return this.defaultEncryptor;
    }

    public void setDefaultEncryptor(Class<? extends IEncryptor> defaultEncryptor) {
        this.defaultEncryptor = defaultEncryptor;
    }

    public String getDefaultKey() {
        return this.defaultKey;
    }

    public void setDefaultKey(String defaultKey) {
        this.defaultKey = defaultKey;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public List<String> getMappedKeyPrefixes() {
        return this.mappedKeyPrefixes;
    }

    public void setMappedKeyPrefixes(List<String> mappedKeyPrefixes) {
        this.mappedKeyPrefixes = mappedKeyPrefixes;
    }

    public String getTypePackages() {
        return this.typePackages;
    }

    public void setTypePackages(String typePackages) {
        this.typePackages = typePackages;
    }

    public boolean isKeepParameter() {
        return this.keepParameter;
    }

    public void setKeepParameter(boolean keepParameter) {
        this.keepParameter = keepParameter;
    }

    private void validate() {
        if (this.defaultKey == null || this.defaultKey.trim().equals("")) {
            throw new IllegalStateException("mybatis.crypto.default-key missing");
        }
        if (this.defaultEncryptor == null) {
            throw new IllegalStateException("mybatis.crypto.default-encryptor missing");
        }
    }

    MybatisCryptoConfig toMybatisCryptoConfig() {
        if (this.mybatisCryptoConfig == null) {
            this.validate();
            this.mybatisCryptoConfig = new MybatisCryptoConfig(this.mappedKeyPrefixes, this.failFast, this.defaultKey, this.defaultEncryptor, this.keepParameter);
        }
        return this.mybatisCryptoConfig;
    }
}

