/*
 * Decompiled with CFR 0.152.
 */
package io.github.whitedg.mybatis.crypto;

import io.github.whitedg.mybatis.crypto.EncryptedField;
import io.github.whitedg.mybatis.crypto.EncryptedFieldsProvider;
import io.github.whitedg.mybatis.crypto.EncryptorProvider;
import io.github.whitedg.mybatis.crypto.IEncryptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.ibatis.io.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

class MybatisCryptoInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisCryptoInitializer.class);
    private static final ResourcePatternResolver RESOURCE_PATTERN_RESOLVER = new PathMatchingResourcePatternResolver();
    private static final MetadataReaderFactory METADATA_READER_FACTORY = new CachingMetadataReaderFactory();

    MybatisCryptoInitializer() {
    }

    void asyncPreLoad(String packagePatterns, Class<? extends IEncryptor> defaultEncryptor) throws IOException {
        new PreLoadThread(packagePatterns, defaultEncryptor).start();
    }

    private static Set<Class<?>> scanClasses(String packagePatterns) throws IOException {
        String[] packagePatternArray;
        HashSet classes = new HashSet();
        for (String packagePattern : packagePatternArray = StringUtils.tokenizeToStringArray((String)packagePatterns, (String)",; \t\n")) {
            Resource[] resources;
            for (Resource resource : resources = RESOURCE_PATTERN_RESOLVER.getResources("classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packagePattern) + "/**/*.class")) {
                try {
                    ClassMetadata classMetadata = METADATA_READER_FACTORY.getMetadataReader(resource).getClassMetadata();
                    Class clazz = Resources.classForName((String)classMetadata.getClassName());
                    classes.add(clazz);
                }
                catch (Throwable e) {
                    LOGGER.warn("Cannot load the '" + resource + "'. Cause by " + e.toString());
                }
            }
        }
        return classes;
    }

    private static class PreLoadThread
    extends Thread {
        private final String packagePatterns;
        private final Class<? extends IEncryptor> defaultEncryptor;

        public PreLoadThread(String packagePatterns, Class<? extends IEncryptor> defaultEncryptor) {
            this.packagePatterns = packagePatterns;
            this.defaultEncryptor = defaultEncryptor;
            this.setName("MybatisCryptoPreLoadThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Set classes;
            LOGGER.info("Pre-Loading EncryptedFields by Mybatis-Crypto...");
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            try {
                classes = MybatisCryptoInitializer.scanClasses(this.packagePatterns);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            classes.stream().filter(clazz -> !clazz.isAnonymousClass()).filter(clazz -> !clazz.isInterface()).filter(clazz -> !clazz.isMemberClass()).forEach(clazz -> {
                Set encryptedFields = EncryptedFieldsProvider.get((Class)clazz);
                if (!CollectionUtils.isEmpty((Collection)encryptedFields)) {
                    LOGGER.debug("{} encrypted field(s) found for {}", (Object)encryptedFields.size(), clazz);
                    for (Field field : encryptedFields) {
                        EncryptedField encryptedField = field.getAnnotation(EncryptedField.class);
                        if (encryptedField == null) continue;
                        EncryptorProvider.getOrDefault((EncryptedField)encryptedField, this.defaultEncryptor);
                    }
                }
            });
            stopWatch.stop();
            LOGGER.info("Pre-Loading EncryptedFields by Mybatis-Crypto completed in {}ms", (Object)stopWatch.getTotalTimeMillis());
        }
    }
}

