/*
 * Decompiled with CFR 0.152.
 */
package io.github.whitedg.mybatis.crypto;

import io.github.whitedg.mybatis.crypto.MybatisCryptoInitializer;
import io.github.whitedg.mybatis.crypto.MybatisCryptoProperties;
import io.github.whitedg.mybatis.crypto.MybatisDecryptionPlugin;
import io.github.whitedg.mybatis.crypto.MybatisEncryptionPlugin;
import io.github.whitedg.mybatis.crypto.MybatisQueryEncryptionPlugin;
import java.io.IOException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="mybatis-crypto", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={MybatisCryptoProperties.class})
public class MyBatisCryptoAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MybatisCryptoInitializer.class})
    @ConditionalOnProperty(prefix="mybatis-crypto", name={"type-packages"})
    public MybatisCryptoInitializer mybatisCryptoInitializer(MybatisCryptoProperties properties) {
        MybatisCryptoInitializer initializer = new MybatisCryptoInitializer();
        try {
            initializer.asyncPreLoad(properties.getTypePackages(), properties.getDefaultEncryptor());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return initializer;
    }

    @Bean
    @ConditionalOnMissingBean(value={MybatisEncryptionPlugin.class})
    public MybatisEncryptionPlugin encryptionInterceptor(MybatisCryptoProperties properties) {
        return new MybatisEncryptionPlugin(properties.toMybatisCryptoConfig());
    }

    @Bean
    @ConditionalOnMissingBean(value={MybatisDecryptionPlugin.class})
    public MybatisDecryptionPlugin decryptionInterceptor(MybatisCryptoProperties properties) {
        return new MybatisDecryptionPlugin(properties.toMybatisCryptoConfig());
    }

    @Bean
    @ConditionalOnProperty(prefix="mybatis-crypto", name={"encrypted-query"}, havingValue="true")
    @ConditionalOnMissingBean(value={MybatisQueryEncryptionPlugin.class})
    public MybatisQueryEncryptionPlugin queryEncryptionInterceptor(MybatisCryptoProperties properties) {
        return new MybatisQueryEncryptionPlugin(properties.toMybatisCryptoConfig());
    }
}

