/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.transcoders;

import net.spy.memcached.CachedData;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.transcoders.TranscoderUtils;

public final class IntegerTranscoder
extends SpyObject
implements Transcoder<Integer> {
    private static final int flags = 512;
    private final TranscoderUtils tu = new TranscoderUtils(true);

    @Override
    public boolean asyncDecode(CachedData d) {
        return false;
    }

    @Override
    public CachedData encode(Integer l) {
        return new CachedData(512, this.tu.encodeInt(l), this.getMaxSize());
    }

    @Override
    public Integer decode(CachedData d) {
        if (512 == d.getFlags()) {
            return this.tu.decodeInt(d.getData());
        }
        return null;
    }

    @Override
    public int getMaxSize() {
        return 0x100000;
    }
}

