/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.binary.OperationImpl;

public abstract class SASLBaseOperationImpl
extends OperationImpl {
    private static final int SASL_CONTINUE = 33;
    protected final String[] mech;
    protected final byte[] challenge;
    protected final String serverName;
    protected final Map<String, ?> props;
    protected final CallbackHandler cbh;

    public SASLBaseOperationImpl(int c, String[] m, byte[] ch, String s, Map<String, ?> p, CallbackHandler h, OperationCallback cb) {
        super(c, SASLBaseOperationImpl.generateOpaque(), cb);
        this.mech = m;
        this.challenge = ch;
        this.serverName = s;
        this.props = p;
        this.cbh = h;
    }

    @Override
    public void initialize() {
        try {
            SaslClient sc = Sasl.createSaslClient(this.mech, null, "memcached", this.serverName, this.props, this.cbh);
            byte[] response = this.buildResponse(sc);
            String mechanism = sc.getMechanismName();
            this.prepareBuffer(mechanism, 0L, response, new Object[0]);
        }
        catch (SaslException e) {
            throw new RuntimeException("Can't make SASL go.", e);
        }
    }

    protected abstract byte[] buildResponse(SaslClient var1) throws SaslException;

    @Override
    protected void decodePayload(byte[] pl) {
        this.getLogger().debug("Auth response:  %s", new String(pl));
    }

    @Override
    protected void finishedPayload(byte[] pl) throws IOException {
        if (this.errorCode == 33) {
            this.getCallback().receivedStatus(new OperationStatus(true, new String(pl)));
            this.transitionState(OperationState.COMPLETE);
        } else if (this.errorCode == 0) {
            this.getCallback().receivedStatus(new OperationStatus(true, ""));
            this.transitionState(OperationState.COMPLETE);
        } else {
            super.finishedPayload(pl);
        }
    }
}

