/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatsOperation;
import net.spy.memcached.protocol.ascii.OperationImpl;

final class StatsOperationImpl
extends OperationImpl
implements StatsOperation {
    private static final OperationStatus END = new OperationStatus(true, "END");
    private static final byte[] MSG = "stats\r\n".getBytes();
    private final byte[] msg;
    private final StatsOperation.Callback cb;

    public StatsOperationImpl(String arg, StatsOperation.Callback c) {
        super(c);
        this.cb = c;
        this.msg = arg == null ? MSG : ("stats " + arg + "\r\n").getBytes();
    }

    @Override
    public void handleLine(String line) {
        if (line.startsWith("END")) {
            this.cb.receivedStatus(END);
            this.transitionState(OperationState.COMPLETE);
        } else {
            String[] parts = line.split(" ", 3);
            assert (parts.length == 3);
            this.cb.gotStat(parts[1], parts[2]);
        }
    }

    @Override
    public void initialize() {
        this.setBuffer(ByteBuffer.wrap(this.msg));
    }

    @Override
    protected void wasCancelled() {
        this.cb.receivedStatus(CANCELLED);
    }
}

