/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationErrorType;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.BaseOperationImpl;
import net.spy.memcached.protocol.ascii.OperationReadType;

abstract class OperationImpl
extends BaseOperationImpl
implements Operation {
    protected static final byte[] CRLF = new byte[]{13, 10};
    private static final String CHARSET = "UTF-8";
    private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    OperationReadType readType = OperationReadType.LINE;
    boolean foundCr = false;

    protected OperationImpl() {
    }

    protected OperationImpl(OperationCallback cb) {
        this.callback = cb;
    }

    protected final OperationStatus matchStatus(String line, OperationStatus ... statii) {
        OperationStatus rv = null;
        for (OperationStatus status : statii) {
            if (!line.equals(status.getMessage())) continue;
            rv = status;
        }
        if (rv == null) {
            rv = new OperationStatus(false, line);
        }
        return rv;
    }

    protected final OperationReadType getReadType() {
        return this.readType;
    }

    protected final void setReadType(OperationReadType to) {
        this.readType = to;
    }

    protected final void setArguments(ByteBuffer bb, Object ... args) {
        boolean wasFirst = true;
        for (Object o : args) {
            String s = String.valueOf(o);
            if (wasFirst) {
                wasFirst = false;
            } else if (!"".equals(s)) {
                bb.put((byte)32);
            }
            bb.put(KeyUtil.getKeyBytes(s));
        }
        bb.put(CRLF);
    }

    OperationErrorType classifyError(String line) {
        OperationErrorType rv = null;
        if (line.startsWith("ERROR")) {
            rv = OperationErrorType.GENERAL;
        } else if (line.startsWith("CLIENT_ERROR")) {
            rv = OperationErrorType.CLIENT;
        } else if (line.startsWith("SERVER_ERROR")) {
            rv = OperationErrorType.SERVER;
        }
        return rv;
    }

    @Override
    public void readFromBuffer(ByteBuffer data) throws IOException {
        while (this.getState() != OperationState.COMPLETE && data.remaining() > 0) {
            if (this.readType == OperationReadType.DATA) {
                this.handleRead(data);
                continue;
            }
            int offset = -1;
            int i = 0;
            while (data.remaining() > 0) {
                byte b = data.get();
                if (b == 13) {
                    this.foundCr = true;
                } else {
                    if (b == 10) {
                        assert (this.foundCr) : "got a \\n without a \\r";
                        offset = i;
                        this.foundCr = false;
                        break;
                    }
                    assert (!this.foundCr) : "got a \\r without a \\n";
                    this.byteBuffer.write(b);
                }
                ++i;
            }
            if (offset < 0) continue;
            String line = new String(this.byteBuffer.toByteArray(), CHARSET);
            this.byteBuffer.reset();
            OperationErrorType eType = this.classifyError(line);
            if (eType != null) {
                this.handleError(eType, line);
                continue;
            }
            this.handleLine(line);
        }
    }

    public abstract void handleLine(String var1);
}

