/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import net.spy.memcached.ops.FlushOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;

final class FlushByPrefixOperationImpl
extends OperationImpl
implements FlushOperation {
    private static final OperationStatus OK = new OperationStatus(true, "OK");
    private static final OperationStatus NOT_FOUND = new OperationStatus(true, "NOT_FOUND");
    private final String prefix;
    private final int delay;
    private final boolean noreply;

    public FlushByPrefixOperationImpl(String prefix, int delay, boolean noreply, OperationCallback cb) {
        super(cb);
        this.prefix = prefix;
        this.delay = delay;
        this.noreply = noreply;
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Flush completed successfully");
        this.getCallback().receivedStatus(this.matchStatus(line, OK, NOT_FOUND));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        StringBuilder sb = new StringBuilder();
        sb.append("flush_prefix ");
        sb.append(this.prefix);
        if (this.delay != -1) {
            sb.append(" ").append(this.delay);
        }
        if (this.noreply) {
            sb.append(" noreply");
        }
        sb.append("\r\n");
        ByteBuffer bb = ByteBuffer.allocate(sb.length());
        bb.put(sb.toString().getBytes());
        bb.flip();
        this.setBuffer(bb);
    }
}

