/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.collection.CollectionMutate;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.CollectionMutateOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class CollectionMutateOperationImpl
extends OperationImpl
implements CollectionMutateOperation {
    private static final OperationStatus GET_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    private static final OperationStatus UNREADABLE = new CollectionOperationStatus(false, "UNREADABLE", CollectionResponse.UNREADABLE);
    private static final OperationStatus NOT_FOUND_ELEMENT = new CollectionOperationStatus(false, "NOT_FOUND_ELEMENT", CollectionResponse.NOT_FOUND_ELEMENT);
    protected final String key;
    protected final String subkey;
    protected final CollectionMutate collectionMutate;

    public CollectionMutateOperationImpl(String key, String subkey, CollectionMutate collectionMutate, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.subkey = subkey;
        this.collectionMutate = collectionMutate;
    }

    @Override
    public void handleLine(String line) {
        OperationStatus status = null;
        try {
            Long.valueOf(line);
            this.getCallback().receivedStatus(new OperationStatus(true, line));
        }
        catch (NumberFormatException e) {
            status = this.matchStatus(line, NOT_FOUND, TYPE_MISMATCH, BKEY_MISMATCH, UNREADABLE, NOT_FOUND_ELEMENT);
            this.getLogger().debug(status);
            this.getCallback().receivedStatus(status);
        }
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        String cmd = this.collectionMutate.getCommand();
        String args = this.collectionMutate.stringify();
        ByteBuffer bb = ByteBuffer.allocate(this.key.length() + this.subkey.length() + cmd.length() + args.length() + 16);
        this.setArguments(bb, cmd, this.key, this.subkey, args);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(GET_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    public String getSubKey() {
        return this.subkey;
    }
}

