/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.collection.CollectionDelete;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.CollectionDeleteOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class CollectionDeleteOperationImpl
extends OperationImpl
implements CollectionDeleteOperation {
    private static final OperationStatus DELETE_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus DELETED = new CollectionOperationStatus(true, "DELETED", CollectionResponse.DELETED);
    private static final OperationStatus DELETED_DROPPED = new CollectionOperationStatus(true, "DELETED_DROPPED", CollectionResponse.DELETED_DROPPED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus NOT_FOUND_ELEMENT = new CollectionOperationStatus(false, "NOT_FOUND_ELEMENT", CollectionResponse.NOT_FOUND_ELEMENT);
    private static final OperationStatus OUT_OF_RANGE = new CollectionOperationStatus(false, "OUT_OF_RANGE", CollectionResponse.OUT_OF_RANGE);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    protected String key;
    protected CollectionDelete<?> collectionDelete;

    public CollectionDeleteOperationImpl(String key, CollectionDelete<?> collectionDelete, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.collectionDelete = collectionDelete;
    }

    @Override
    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        OperationStatus status = this.matchStatus(line, DELETED, DELETED_DROPPED, NOT_FOUND, NOT_FOUND_ELEMENT, OUT_OF_RANGE, TYPE_MISMATCH, BKEY_MISMATCH);
        this.getCallback().receivedStatus(status);
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        String cmd = this.collectionDelete.getCommand();
        String args = this.collectionDelete.stringify();
        byte[] data = this.collectionDelete.getData();
        ByteBuffer bb = ByteBuffer.allocate(this.key.length() + cmd.length() + args.length() + data.length + 16);
        this.setArguments(bb, cmd, this.key, args);
        if ("sop delete".equals(cmd)) {
            bb.put(data);
            bb.put(CRLF);
        } else if (data.length > 0) {
            bb.put(data);
            bb.put(CRLF);
        }
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(DELETE_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public CollectionDelete<?> getDelete() {
        return this.collectionDelete;
    }
}

