/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.collection.CollectionCount;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.CollectionCountOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class CollectionCountOperationImpl
extends OperationImpl
implements CollectionCountOperation {
    private static final OperationStatus GET_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    private static final OperationStatus UNREADABLE = new CollectionOperationStatus(false, "UNREADABLE", CollectionResponse.UNREADABLE);
    protected final String key;
    protected final CollectionCount collectionCount;
    protected int count = 0;

    public CollectionCountOperationImpl(String key, CollectionCount collectionCount, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.collectionCount = collectionCount;
    }

    @Override
    public void handleLine(String line) {
        String[] stuff;
        if (line.startsWith("COUNT=")) {
            this.getLogger().debug("Got line %s", line);
            stuff = line.split("=");
            assert ("COUNT".equals(stuff[0]));
        } else {
            OperationStatus status = this.matchStatus(line, NOT_FOUND, TYPE_MISMATCH, BKEY_MISMATCH, UNREADABLE);
            this.getLogger().debug(status);
            this.getCallback().receivedStatus(status);
            this.transitionState(OperationState.COMPLETE);
            return;
        }
        this.count = Integer.parseInt(stuff[1]);
        this.getCallback().receivedStatus(new CollectionOperationStatus(new OperationStatus(true, String.valueOf(this.count))));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        String cmd = this.collectionCount.getCommand();
        String args = this.collectionCount.stringify();
        ByteBuffer bb = ByteBuffer.allocate(this.key.length() + cmd.length() + args.length() + 16);
        this.setArguments(bb, cmd, this.key, args);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(GET_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }
}

