/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.util.Map;
import net.spy.memcached.collection.CollectionGet;
import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.util.BTreeUtil;

public class ExtendedBTreeGet<T>
extends CollectionGet<T> {
    private static final String command = "bop get";
    protected String range;
    protected int offset = -1;
    protected int count = -1;
    protected Map<Integer, T> map;
    protected byte[] subkey;
    protected ElementFlagFilter elementFlagFilter;
    private int headerParseStep = 1;
    private boolean elementFlagExists = false;

    public ExtendedBTreeGet(byte[] from, byte[] to, int offset, int count, boolean delete, boolean dropIfEmpty, ElementFlagFilter elementFlagFilter) {
        this.headerCount = 2;
        this.range = BTreeUtil.toHex(from) + ".." + BTreeUtil.toHex(to);
        this.offset = offset;
        this.count = count;
        this.delete = delete;
        this.dropIfEmpty = dropIfEmpty;
        this.elementFlagFilter = elementFlagFilter;
    }

    public ElementFlagFilter getElementFlagFilter() {
        return this.elementFlagFilter;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Map<Integer, T> getMap() {
        return this.map;
    }

    public byte[] getLongSubkey() {
        return this.subkey;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.range);
        if (this.elementFlagFilter != null) {
            b.append(" ").append(this.elementFlagFilter.toString());
        }
        if (this.offset > 0) {
            b.append(" ").append(this.offset);
        }
        if (this.count > 0) {
            b.append(" ").append(this.count);
        }
        if (this.delete && this.dropIfEmpty) {
            b.append(" drop");
        }
        if (this.delete && !this.dropIfEmpty) {
            b.append(" delete");
        }
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }

    public void resetHeaderCount(int count) {
        this.headerCount = count;
    }

    @Override
    public boolean eachRecordParseCompleted() {
        if (this.elementFlagExists) {
            return this.headerParseStep == 1;
        }
        return true;
    }

    @Override
    public boolean headerReady(int spaceCount) {
        return spaceCount == 2 || spaceCount == 3;
    }

    @Override
    public void decodeItemHeader(String itemHeader) {
        String[] splited = itemHeader.split(" ");
        if (this.headerParseStep == 1) {
            if (splited[1].startsWith("0x")) {
                this.elementFlagExists = true;
                this.subkey = BTreeUtil.hexStringToByteArrays(splited[0].substring(2));
                this.elementFlag = BTreeUtil.hexStringToByteArrays(splited[1].substring(2));
                this.headerParseStep = 2;
            } else {
                this.subkey = BTreeUtil.hexStringToByteArrays(splited[0].substring(2));
                this.dataLength = Integer.parseInt(splited[1]);
            }
        } else {
            this.headerParseStep = 1;
            this.dataLength = Integer.parseInt(splited[1]);
        }
    }
}

