/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.util.BTreeUtil;

public class ElementFlagUpdate {
    public static final ElementFlagUpdate RESET_FLAG = new ElementFlagUpdate();
    private final int elementFlagOffset;
    private final ElementFlagFilter.BitWiseOperands bitOp;
    private final byte[] elementFlag;

    private ElementFlagUpdate() {
        this.elementFlag = new byte[0];
        this.elementFlagOffset = -1;
        this.bitOp = null;
    }

    public ElementFlagUpdate(byte[] elementFlag) {
        if (elementFlag == null) {
            throw new IllegalArgumentException("element flag may not null.");
        }
        if (elementFlag.length < 1 || elementFlag.length > 31) {
            throw new IllegalArgumentException("length of element flag must be between 1 and 31");
        }
        this.elementFlag = elementFlag;
        this.elementFlagOffset = -1;
        this.bitOp = null;
    }

    public ElementFlagUpdate(int elementFlagOffset, ElementFlagFilter.BitWiseOperands bitOp, byte[] elementFlag) {
        if (elementFlagOffset < 0) {
            throw new IllegalArgumentException("elementFlagOffset must be larger than 0.");
        }
        if (bitOp == null) {
            throw new IllegalArgumentException("bitOp may not null.");
        }
        if (elementFlag == null) {
            throw new IllegalArgumentException("element flag may not null.");
        }
        if (elementFlag.length < 1 || elementFlag.length > 31) {
            throw new IllegalArgumentException("length of element flag must be between 1 and 31");
        }
        this.elementFlagOffset = elementFlagOffset;
        this.bitOp = bitOp;
        this.elementFlag = elementFlag;
    }

    public int getElementFlagOffset() {
        return this.elementFlagOffset;
    }

    public ElementFlagFilter.BitWiseOperands getBitOp() {
        return this.bitOp;
    }

    public byte[] getElementFlag() {
        return this.elementFlag;
    }

    public String getElementFlagByHex() {
        return BTreeUtil.toHex(this.elementFlag);
    }
}

