/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.spy.memcached.CachedData;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.CollectionObject;
import net.spy.memcached.collection.Element;
import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.collection.ElementFlagUpdate;
import net.spy.memcached.transcoders.Transcoder;

public abstract class CollectionPipedUpdate<T>
extends CollectionObject {
    public static final String PIPE = "pipe";
    public static final int MAX_PIPED_ITEM_COUNT = 500;
    protected String key;
    protected Transcoder<T> tc;
    protected int itemCount;

    public abstract ByteBuffer getAsciiCommand();

    public abstract ByteBuffer getBinaryCommand();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public static class BTreePipedUpdate<T>
    extends CollectionPipedUpdate<T> {
        private static final String COMMAND = "bop update";
        private List<Element<T>> elements;

        public BTreePipedUpdate(String key, List<Element<T>> elements, Transcoder<T> tc) {
            this.key = key;
            this.elements = elements;
            this.tc = tc;
            this.itemCount = elements.size();
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            byte[] elementFlag;
            ElementFlagUpdate elementFlagUpdate;
            int capacity = 0;
            ArrayList<byte[]> decodedList = new ArrayList<byte[]>(this.elements.size());
            CachedData cd = null;
            for (Element<T> each : this.elements) {
                if (each.getValue() != null) {
                    cd = this.tc.encode(each.getValue());
                    decodedList.add(cd.getData());
                    continue;
                }
                decodedList.add(null);
            }
            int i = 0;
            for (Element<T> each : this.elements) {
                elementFlagUpdate = each.getElementFlagUpdate();
                if (elementFlagUpdate != null && (elementFlag = elementFlagUpdate.getElementFlag()) != null) {
                    capacity += KeyUtil.getKeyBytes(elementFlagUpdate.getElementFlagByHex()).length;
                    if (elementFlagUpdate.getElementFlagOffset() > -1) {
                        capacity += 6;
                    }
                }
                capacity += KeyUtil.getKeyBytes(this.key).length;
                capacity += KeyUtil.getKeyBytes(each.isByteArraysBkey() ? each.getBkeyByHex() : String.valueOf(each.getLongBkey())).length;
                if (decodedList.get(i) != null) {
                    capacity += ((byte[])decodedList.get(i++)).length;
                }
                capacity += 64;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity);
            i = 0;
            Iterator<Element<T>> iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                Element<T> element = iterator.next();
                int flagOffset = -1;
                ElementFlagFilter.BitWiseOperands bitOp = null;
                elementFlag = null;
                byte[] value = (byte[])decodedList.get(i++);
                elementFlagUpdate = element.getElementFlagUpdate();
                StringBuilder b = new StringBuilder();
                if (elementFlagUpdate != null && (elementFlag = elementFlagUpdate.getElementFlag()) != null) {
                    if (elementFlag.length > 0) {
                        flagOffset = elementFlagUpdate.getElementFlagOffset();
                        bitOp = elementFlagUpdate.getBitOp();
                        if (flagOffset > -1 && bitOp != null) {
                            b.append(flagOffset).append(" ").append((Object)bitOp).append(" ");
                        }
                        b.append(elementFlagUpdate.getElementFlagByHex());
                    } else {
                        b.append("0");
                    }
                }
                this.setArguments(bb, COMMAND, this.key, element.isByteArraysBkey() ? element.getBkeyByHex() : String.valueOf(element.getLongBkey()), b.toString(), value == null ? -1 : value.length, iterator.hasNext() ? CollectionPipedUpdate.PIPE : "");
                if (value == null) continue;
                if (value.length > 0) {
                    bb.put(value);
                }
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }
}

