/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.spy.memcached.CachedData;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.CollectionAttributes;
import net.spy.memcached.collection.CollectionObject;
import net.spy.memcached.collection.Element;
import net.spy.memcached.transcoders.Transcoder;

public abstract class CollectionPipedStore<T>
extends CollectionObject {
    public static final String PIPE = "pipe";
    public static final int MAX_PIPED_ITEM_COUNT = 500;
    protected String key;
    protected boolean createKeyIfNotExists;
    protected Transcoder<T> tc;
    protected int itemCount;
    protected CollectionAttributes attribute;

    public abstract ByteBuffer getAsciiCommand();

    public abstract ByteBuffer getBinaryCommand();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean iscreateKeyIfNotExists() {
        return this.createKeyIfNotExists;
    }

    public void setcreateKeyIfNotExists(boolean createKeyIfNotExists) {
        this.createKeyIfNotExists = createKeyIfNotExists;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public static class ByteArraysBTreePipedStore<T>
    extends CollectionPipedStore<T> {
        private static final String COMMAND = "bop insert";
        private List<Element<T>> elements;

        public ByteArraysBTreePipedStore(String key, List<Element<T>> elements, boolean createKeyIfNotExists, CollectionAttributes attr, Transcoder<T> tc) {
            this.key = key;
            this.elements = elements;
            this.createKeyIfNotExists = createKeyIfNotExists;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = elements.size();
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            ArrayList<byte[]> decodedList = new ArrayList<byte[]>(this.elements.size());
            CachedData cd = null;
            for (Element<T> each : this.elements) {
                cd = this.tc.encode(each.getValue());
                decodedList.add(cd.getData());
            }
            int i = 0;
            for (Element<T> each : this.elements) {
                capacity += KeyUtil.getKeyBytes(this.key).length;
                capacity += KeyUtil.getKeyBytes(each.isByteArraysBkey() ? each.getBkeyByHex() : String.valueOf(each.getLongBkey())).length;
                capacity += KeyUtil.getKeyBytes(each.getFlagByHex()).length;
                capacity += ((byte[])decodedList.get(i++)).length;
                capacity += 64;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity);
            i = 0;
            Iterator<Element<T>> iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                Element<T> element = iterator.next();
                byte[] value = (byte[])decodedList.get(i++);
                Object[] objectArray = new Object[12];
                objectArray[0] = COMMAND;
                objectArray[1] = this.key;
                objectArray[2] = element.isByteArraysBkey() ? element.getBkeyByHex() : String.valueOf(element.getLongBkey());
                objectArray[3] = element.getFlagByHex();
                objectArray[4] = value.length;
                objectArray[5] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[6] = this.createKeyIfNotExists ? Integer.valueOf(cd.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[7] = "");
                Object object3 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : (objectArray[8] = "");
                Object object4 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getOverflowAction() != null ? this.attribute.getOverflowAction().toString() : "") : (objectArray[9] = "");
                objectArray[10] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getReadable() != null && !this.attribute.getReadable().booleanValue() ? "unreadable" : "") : "";
                objectArray[11] = iterator.hasNext() ? CollectionPipedStore.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(value);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class BTreePipedStore<T>
    extends CollectionPipedStore<T> {
        private static final String COMMAND = "bop insert";
        private Map<Long, T> map;

        public BTreePipedStore(String key, Map<Long, T> map, boolean createKeyIfNotExists, CollectionAttributes attr, Transcoder<T> tc) {
            this.key = key;
            this.map = map;
            this.createKeyIfNotExists = createKeyIfNotExists;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = map.size();
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            ArrayList<byte[]> decodedList = new ArrayList<byte[]>(this.map.size());
            CachedData cd = null;
            for (T each : this.map.values()) {
                cd = this.tc.encode(each);
                decodedList.add(cd.getData());
            }
            int i = 0;
            for (Long eachBkey : this.map.keySet()) {
                capacity += KeyUtil.getKeyBytes(this.key).length;
                capacity += KeyUtil.getKeyBytes(String.valueOf(eachBkey)).length;
                capacity += ((byte[])decodedList.get(i++)).length;
                capacity += 64;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity);
            i = 0;
            Iterator<Long> iterator = this.map.keySet().iterator();
            while (iterator.hasNext()) {
                Long bkey = iterator.next();
                byte[] value = (byte[])decodedList.get(i++);
                Object[] objectArray = new Object[9];
                objectArray[0] = COMMAND;
                objectArray[1] = this.key;
                objectArray[2] = bkey;
                objectArray[3] = value.length;
                objectArray[4] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[5] = this.createKeyIfNotExists ? Integer.valueOf(cd.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[6] = "");
                objectArray[7] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : "";
                objectArray[8] = iterator.hasNext() ? CollectionPipedStore.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(value);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class SetPipedStore<T>
    extends CollectionPipedStore<T> {
        private static final String COMMAND = "sop insert";
        private Collection<T> set;

        public SetPipedStore(String key, Collection<T> set, boolean createKeyIfNotExists, CollectionAttributes attr, Transcoder<T> tc) {
            this.key = key;
            this.set = set;
            this.createKeyIfNotExists = createKeyIfNotExists;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = set.size();
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            ArrayList<byte[]> encodedList = new ArrayList<byte[]>(this.set.size());
            CachedData cd = null;
            for (Object each : this.set) {
                cd = this.tc.encode(each);
                encodedList.add(cd.getData());
            }
            Iterator<Object> i$ = encodedList.iterator();
            while (i$.hasNext()) {
                Object each;
                each = (byte[])i$.next();
                capacity += KeyUtil.getKeyBytes(this.key).length;
                capacity += ((T)each).length;
                capacity += 64;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity);
            Iterator iterator = encodedList.iterator();
            while (iterator.hasNext()) {
                byte[] each = (byte[])iterator.next();
                Object[] objectArray = new Object[8];
                objectArray[0] = COMMAND;
                objectArray[1] = this.key;
                objectArray[2] = each.length;
                objectArray[3] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[4] = this.createKeyIfNotExists ? Integer.valueOf(cd.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[5] = "");
                objectArray[6] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : "";
                objectArray[7] = iterator.hasNext() ? CollectionPipedStore.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(each);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class ListPipedStore<T>
    extends CollectionPipedStore<T> {
        private static final String COMMAND = "lop insert";
        private Collection<T> list;
        private int index;

        public ListPipedStore(String key, int index, Collection<T> list, boolean createKeyIfNotExists, CollectionAttributes attr, Transcoder<T> tc) {
            this.key = key;
            this.index = index;
            this.list = list;
            this.createKeyIfNotExists = createKeyIfNotExists;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = list.size();
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            ArrayList<byte[]> encodedList = new ArrayList<byte[]>(this.list.size());
            CachedData cd = null;
            for (Object each : this.list) {
                cd = this.tc.encode(each);
                encodedList.add(cd.getData());
            }
            Iterator<Object> i$ = encodedList.iterator();
            while (i$.hasNext()) {
                Object each;
                each = (byte[])i$.next();
                capacity += KeyUtil.getKeyBytes(this.key).length;
                capacity += ((T)each).length;
                capacity += 64;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity);
            Iterator iterator = encodedList.iterator();
            while (iterator.hasNext()) {
                byte[] each = (byte[])iterator.next();
                Object[] objectArray = new Object[9];
                objectArray[0] = COMMAND;
                objectArray[1] = this.key;
                objectArray[2] = this.index;
                objectArray[3] = each.length;
                objectArray[4] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[5] = this.createKeyIfNotExists ? Integer.valueOf(cd.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[6] = "");
                objectArray[7] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : "";
                objectArray[8] = iterator.hasNext() ? CollectionPipedStore.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(each);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }
}

