/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.CollectionAttributes;
import net.spy.memcached.collection.CollectionOverflowAction;

public abstract class CollectionCreate {
    protected int flags;
    protected int expTime;
    protected long maxCount;
    protected CollectionOverflowAction overflowAction;
    protected Boolean readable;
    protected boolean noreply;
    protected String str;

    public CollectionCreate() {
    }

    public CollectionCreate(int flags, Integer expTime, Long maxCount, CollectionOverflowAction overflowAction, Boolean readable, boolean noreply) {
        this.flags = flags;
        this.expTime = null == expTime ? CollectionAttributes.DEFAULT_EXPIRETIME : expTime;
        this.maxCount = null == maxCount ? CollectionAttributes.DEFAULT_MAXCOUNT : maxCount;
        this.overflowAction = overflowAction;
        this.readable = readable;
        this.noreply = noreply;
    }

    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.flags);
        b.append(' ').append(this.expTime);
        b.append(' ').append(this.maxCount);
        if (null != this.overflowAction) {
            b.append(' ').append((Object)this.overflowAction);
        }
        if (null != this.readable && !this.readable.booleanValue()) {
            b.append(' ').append("unreadable");
        }
        if (this.noreply) {
            b.append(b.length() <= 0 ? "" : " ").append("noreply");
        }
        this.str = b.toString();
        return this.str;
    }

    public String toString() {
        return this.str != null ? this.str : this.stringify();
    }

    public abstract String getCommand();
}

