/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import net.spy.memcached.CachedData;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.CollectionAttributes;
import net.spy.memcached.collection.CollectionObject;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.util.BTreeUtil;

public abstract class CollectionBulkStore<T>
extends CollectionObject {
    public static final String PIPE = "pipe";
    public static final int MAX_PIPED_ITEM_COUNT = 500;
    protected List<String> keyList;
    protected T value;
    protected CachedData cachedData;
    protected boolean createKeyIfNotExists;
    protected Transcoder<T> tc;
    protected int itemCount;
    protected CollectionAttributes attribute;

    public abstract ByteBuffer getAsciiCommand();

    public abstract ByteBuffer getBinaryCommand();

    public List<String> getKeyList() {
        return this.keyList;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public static class ListBulkStore<T>
    extends CollectionBulkStore<T> {
        private static final String COMMAND = "lop insert";
        private int index;

        public ListBulkStore(List<String> keyList, int index, T value, CollectionAttributes attr, Transcoder<T> tc) {
            this.keyList = keyList;
            this.index = index;
            this.value = value;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = keyList.size();
            this.createKeyIfNotExists = attr != null;
            this.cachedData = tc.encode(value);
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            int eachExtraSize = String.valueOf(this.index).length() + this.cachedData.getData().length + 64;
            for (String eachKey : this.keyList) {
                capacity += KeyUtil.getKeyBytes(eachKey).length;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity += eachExtraSize * this.keyList.size());
            Iterator iterator = this.keyList.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                byte[] value = this.cachedData.getData();
                Object[] objectArray = new Object[9];
                objectArray[0] = COMMAND;
                objectArray[1] = key;
                objectArray[2] = this.index;
                objectArray[3] = value.length;
                objectArray[4] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[5] = this.createKeyIfNotExists ? Integer.valueOf(this.cachedData.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[6] = "");
                objectArray[7] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : "";
                objectArray[8] = iterator.hasNext() ? CollectionBulkStore.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(value);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class SetBulkStore<T>
    extends CollectionBulkStore<T> {
        private static final String COMMAND = "sop insert";

        public SetBulkStore(List<String> keyList, T value, CollectionAttributes attr, Transcoder<T> tc) {
            this.keyList = keyList;
            this.value = value;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = keyList.size();
            this.createKeyIfNotExists = attr != null;
            this.cachedData = tc.encode(value);
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            int eachExtraSize = this.cachedData.getData().length + 64;
            for (String eachKey : this.keyList) {
                capacity += KeyUtil.getKeyBytes(eachKey).length;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity += eachExtraSize * this.keyList.size());
            Iterator iterator = this.keyList.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                byte[] value = this.cachedData.getData();
                Object[] objectArray = new Object[8];
                objectArray[0] = COMMAND;
                objectArray[1] = key;
                objectArray[2] = value.length;
                objectArray[3] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[4] = this.createKeyIfNotExists ? Integer.valueOf(this.cachedData.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[5] = "");
                objectArray[6] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : "";
                objectArray[7] = iterator.hasNext() ? CollectionBulkStore.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(value);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class BTreeBulkStore<T>
    extends CollectionBulkStore<T> {
        private static final String COMMAND = "bop insert";
        private final String bkey;
        private final String eflag;

        public BTreeBulkStore(List<String> keyList, long bkey, byte[] eflag, T value, CollectionAttributes attr, Transcoder<T> tc) {
            this.keyList = keyList;
            this.bkey = String.valueOf(bkey);
            this.eflag = BTreeUtil.toHex(eflag);
            this.value = value;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = keyList.size();
            this.createKeyIfNotExists = attr != null;
            this.cachedData = tc.encode(value);
        }

        public BTreeBulkStore(List<String> keyList, byte[] bkey, byte[] eflag, T value, CollectionAttributes attr, Transcoder<T> tc) {
            this.keyList = keyList;
            this.bkey = BTreeUtil.toHex(bkey);
            this.eflag = BTreeUtil.toHex(eflag);
            this.value = value;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = keyList.size();
            this.createKeyIfNotExists = attr != null;
            this.cachedData = tc.encode(value);
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            int eachExtraSize = this.bkey.length() + (this.eflag != null ? this.eflag.length() : 0) + this.cachedData.getData().length + 64;
            for (String eachKey : this.keyList) {
                capacity += KeyUtil.getKeyBytes(eachKey).length;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity += eachExtraSize * this.keyList.size());
            Iterator iterator = this.keyList.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                byte[] value = this.cachedData.getData();
                Object[] objectArray = new Object[10];
                objectArray[0] = COMMAND;
                objectArray[1] = key;
                objectArray[2] = this.bkey;
                objectArray[3] = this.eflag != null ? this.eflag : "";
                objectArray[4] = value.length;
                objectArray[5] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[6] = this.createKeyIfNotExists ? Integer.valueOf(this.cachedData.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[7] = "");
                objectArray[8] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : "";
                objectArray[9] = iterator.hasNext() ? CollectionBulkStore.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(value);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }
}

