/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.util.List;
import java.util.Map;
import net.spy.memcached.collection.BTreeGetBulk;
import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.util.BTreeUtil;

public abstract class BTreeGetBulkImpl<T>
implements BTreeGetBulk<T> {
    private static final String command = "bop mget";
    private String commaSeparatedKeys;
    protected String str;
    protected int lenKeys;
    protected List<String> keyList;
    protected String range;
    protected ElementFlagFilter eFlagFilter;
    protected int offset = -1;
    protected int count;
    protected boolean reverse;
    protected Map<Integer, T> map;
    public String key;
    public int flag;
    public Object subkey;
    public int dataLength;
    public byte[] eflag = null;

    protected BTreeGetBulkImpl(List<String> keyList, byte[] from, byte[] to, ElementFlagFilter eFlagFilter, int offset, int count) {
        this.keyList = keyList;
        this.range = BTreeUtil.toHex(from) + ".." + BTreeUtil.toHex(to);
        this.eFlagFilter = eFlagFilter;
        this.offset = offset;
        this.count = count;
        this.reverse = BTreeUtil.compareByteArraysInLexOrder(from, to) > 0;
    }

    protected BTreeGetBulkImpl(List<String> keyList, long from, long to, ElementFlagFilter eFlagFilter, int offset, int count) {
        this.keyList = keyList;
        this.range = String.valueOf(from) + (to > -1L ? ".." + String.valueOf(to) : "");
        this.eFlagFilter = eFlagFilter;
        this.offset = offset;
        this.count = count;
        this.reverse = from > to;
    }

    @Override
    public String getCommaSeparatedKeys() {
        if (this.commaSeparatedKeys != null) {
            return this.commaSeparatedKeys;
        }
        StringBuilder sb = new StringBuilder();
        int numkeys = this.keyList.size();
        for (int i = 0; i < numkeys; ++i) {
            sb.append(this.keyList.get(i));
            if (i + 1 >= numkeys) continue;
            sb.append(",");
        }
        this.commaSeparatedKeys = sb.toString();
        return this.commaSeparatedKeys;
    }

    @Override
    public String getRepresentKey() {
        if (this.keyList == null || this.keyList.isEmpty()) {
            throw new IllegalStateException("Key list is empty.");
        }
        return this.keyList.get(0);
    }

    @Override
    public List<String> getKeyList() {
        return this.keyList;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.getCommaSeparatedKeys().length());
        b.append(" ").append(this.keyList.size());
        b.append(" ").append(this.range);
        if (this.eFlagFilter != null) {
            b.append(" ").append(this.eFlagFilter.toString());
        }
        if (this.offset > 0) {
            b.append(" ").append(this.offset);
        }
        b.append(" ").append(this.count);
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }

    @Override
    public boolean elementHeaderReady(int spaceCount) {
        return spaceCount == 3 || spaceCount == 4;
    }

    @Override
    public boolean keyHeaderReady(int spaceCount) {
        return spaceCount == 3 || spaceCount == 5;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int getFlag() {
        return this.flag;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public byte[] getEFlag() {
        return this.eflag;
    }
}

