/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.ByteArrayBKey;
import net.spy.memcached.util.BTreeUtil;

public class BKeyObject {
    private BKeyType type = BKeyType.UNKNOWN;
    private Long longBKey;
    private ByteArrayBKey byteArrayBKey;

    public BKeyObject() {
    }

    public BKeyObject(long longBKey) {
        this.setLongBKey(longBKey);
    }

    public BKeyObject(byte[] byteArrayBKey) {
        this.setByteArrayBKey(new ByteArrayBKey(byteArrayBKey));
    }

    public BKeyObject(ByteArrayBKey byteArrayBKey) {
        this.setByteArrayBKey(byteArrayBKey);
    }

    public BKeyObject(String bkeyString) {
        byte[] b = BTreeUtil.hexStringToByteArrays(bkeyString);
        ByteArrayBKey byteArrayBKey = new ByteArrayBKey(b);
        this.setByteArrayBKey(byteArrayBKey);
    }

    public BKeyType getType() {
        return this.type;
    }

    public Long getLongBKey() {
        if (BKeyType.LONG == this.type) {
            return this.longBKey;
        }
        return null;
    }

    public void setLongBKey(long longBKey) {
        this.type = BKeyType.LONG;
        this.longBKey = longBKey;
        this.byteArrayBKey = null;
    }

    public ByteArrayBKey getByteArrayBKey() {
        if (BKeyType.BYTEARRAY == this.type) {
            return this.byteArrayBKey;
        }
        return null;
    }

    public byte[] getByteArrayBKeyRaw() {
        if (BKeyType.BYTEARRAY == this.type) {
            return this.byteArrayBKey.getBytes();
        }
        return null;
    }

    public void setByteArrayBKey(ByteArrayBKey byteArrayBKey) {
        this.type = BKeyType.BYTEARRAY;
        this.byteArrayBKey = byteArrayBKey;
        this.longBKey = null;
    }

    public String getBKeyAsString() {
        if (BKeyType.LONG == this.type) {
            return String.valueOf(this.longBKey);
        }
        if (BKeyType.BYTEARRAY == this.type) {
            return BTreeUtil.toHex(this.byteArrayBKey.getBytes());
        }
        return null;
    }

    public String toString() {
        return this.getBKeyAsString();
    }

    public static enum BKeyType {
        LONG,
        BYTEARRAY,
        UNKNOWN;

    }
}

