/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.auth;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class PlainCallbackHandler
implements CallbackHandler {
    private final String username;
    private final char[] password;

    public PlainCallbackHandler(String u, String p) {
        this.username = u;
        this.password = p.toCharArray();
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            if (cb instanceof TextOutputCallback) continue;
            if (cb instanceof NameCallback) {
                NameCallback nc = (NameCallback)cb;
                nc.setName(this.username);
                continue;
            }
            if (cb instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)cb;
                pc.setPassword(this.password);
                continue;
            }
            throw new UnsupportedCallbackException(cb);
        }
    }
}

