/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationTimeoutException;
import net.spy.memcached.internal.BulkFuture;
import net.spy.memcached.transcoders.Transcoder;

public interface MemcachedClientIF {
    public static final int MAX_KEY_LENGTH = 250;

    public Collection<SocketAddress> getAvailableServers();

    public Collection<SocketAddress> getUnavailableServers();

    public Transcoder<Object> getTranscoder();

    public NodeLocator getNodeLocator();

    public Future<Boolean> append(long var1, String var3, Object var4);

    public <T> Future<Boolean> append(long var1, String var3, T var4, Transcoder<T> var5);

    public Future<Boolean> prepend(long var1, String var3, Object var4);

    public <T> Future<Boolean> prepend(long var1, String var3, T var4, Transcoder<T> var5);

    public <T> Future<CASResponse> asyncCAS(String var1, long var2, T var4, Transcoder<T> var5);

    public Future<CASResponse> asyncCAS(String var1, long var2, Object var4);

    public <T> CASResponse cas(String var1, long var2, T var4, Transcoder<T> var5) throws OperationTimeoutException;

    public CASResponse cas(String var1, long var2, Object var4) throws OperationTimeoutException;

    public <T> Future<Boolean> add(String var1, int var2, T var3, Transcoder<T> var4);

    public Future<Boolean> add(String var1, int var2, Object var3);

    public <T> Future<Boolean> set(String var1, int var2, T var3, Transcoder<T> var4);

    public Future<Boolean> set(String var1, int var2, Object var3);

    public <T> Future<Boolean> replace(String var1, int var2, T var3, Transcoder<T> var4);

    public Future<Boolean> replace(String var1, int var2, Object var3);

    public <T> Future<T> asyncGet(String var1, Transcoder<T> var2);

    public Future<Object> asyncGet(String var1);

    public <T> Future<CASValue<T>> asyncGets(String var1, Transcoder<T> var2);

    public Future<CASValue<Object>> asyncGets(String var1);

    public <T> CASValue<T> gets(String var1, Transcoder<T> var2) throws OperationTimeoutException;

    public CASValue<Object> gets(String var1) throws OperationTimeoutException;

    public <T> T get(String var1, Transcoder<T> var2) throws OperationTimeoutException;

    public Object get(String var1) throws OperationTimeoutException;

    public <T> BulkFuture<Map<String, T>> asyncGetBulk(Collection<String> var1, Iterator<Transcoder<T>> var2);

    public <T> BulkFuture<Map<String, T>> asyncGetBulk(Collection<String> var1, Transcoder<T> var2);

    public BulkFuture<Map<String, Object>> asyncGetBulk(Collection<String> var1);

    public <T> BulkFuture<Map<String, T>> asyncGetBulk(Transcoder<T> var1, String ... var2);

    public BulkFuture<Map<String, Object>> asyncGetBulk(String ... var1);

    public <T> Map<String, T> getBulk(Collection<String> var1, Transcoder<T> var2) throws OperationTimeoutException;

    public Map<String, Object> getBulk(Collection<String> var1) throws OperationTimeoutException;

    public <T> Map<String, T> getBulk(Transcoder<T> var1, String ... var2) throws OperationTimeoutException;

    public Map<String, Object> getBulk(String ... var1) throws OperationTimeoutException;

    public Map<SocketAddress, String> getVersions();

    public Map<SocketAddress, Map<String, String>> getStats();

    public Map<SocketAddress, Map<String, String>> getStats(String var1);

    public long incr(String var1, int var2) throws OperationTimeoutException;

    public long decr(String var1, int var2) throws OperationTimeoutException;

    public long incr(String var1, int var2, long var3, int var5) throws OperationTimeoutException;

    public long decr(String var1, int var2, long var3, int var5) throws OperationTimeoutException;

    public Future<Long> asyncIncr(String var1, int var2);

    public Future<Long> asyncDecr(String var1, int var2);

    public long incr(String var1, int var2, long var3) throws OperationTimeoutException;

    public long decr(String var1, int var2, long var3) throws OperationTimeoutException;

    public Future<Boolean> delete(String var1);

    public Future<Boolean> flush(int var1);

    public Future<Boolean> flush();

    public void shutdown();

    public boolean shutdown(long var1, TimeUnit var3);

    public boolean waitForQueues(long var1, TimeUnit var3);

    public boolean addObserver(ConnectionObserver var1);

    public boolean removeObserver(ConnectionObserver var1);

    public Set<String> listSaslMechanisms();
}

