/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.List;
import net.spy.memcached.compat.SpyObject;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class CacheMonitor
extends SpyObject
implements Watcher,
AsyncCallback.ChildrenCallback {
    ZooKeeper zk;
    String serviceCode;
    volatile boolean dead;
    CacheMonitorListener listener;
    List<String> prevChildren;
    public static final String FAKE_SERVER_NODE = "0.0.0.0:23456";

    public CacheMonitor(ZooKeeper zk, String serviceCode, CacheMonitorListener listener) {
        this.zk = zk;
        this.serviceCode = serviceCode;
        this.listener = listener;
        this.getLogger().info("Initializing the CacheMonitor.");
        this.asyncGetCacheList();
    }

    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.None) {
            switch (event.getState()) {
                case SyncConnected: {
                    this.getLogger().warn("Reconnected to the Arcus admin. " + this.getInfo());
                    return;
                }
                case Disconnected: {
                    this.getLogger().warn("Disconnected from the Arcus admin. Trying to reconnect. " + this.getInfo());
                    return;
                }
                case Expired: {
                    this.getLogger().warn("Session expired. Trying to reconnect to the Arcus admin." + this.getInfo());
                    this.shutdown();
                    return;
                }
            }
        } else if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            this.asyncGetCacheList();
        }
    }

    public void processResult(int rc, String path, Object ctx, List<String> children) {
        switch (KeeperException.Code.get((int)rc)) {
            case OK: {
                this.commandNodeChange(children);
                return;
            }
            case NONODE: {
                this.getLogger().fatal("Cannot find your service code. Please contact Arcus support to solve this problem. " + this.getInfo());
                return;
            }
            case SESSIONEXPIRED: {
                this.getLogger().warn("Session expired. Trying to reconnect to the Arcus admin. " + this.getInfo());
                this.shutdown();
                return;
            }
            case NOAUTH: {
                this.getLogger().fatal("Authorization failed " + this.getInfo());
                this.shutdown();
                return;
            }
            case CONNECTIONLOSS: {
                this.getLogger().warn("Connection lost. Trying to reconnect to the Arcus admin." + this.getInfo());
                this.asyncGetCacheList();
                return;
            }
        }
        this.getLogger().warn("Ignoring an unexpected event from the Arcus admin. code=" + KeeperException.Code.get((int)rc) + ", " + this.getInfo());
        this.asyncGetCacheList();
    }

    void asyncGetCacheList() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Set a new watch on " + "/arcus/cache_list/" + this.serviceCode);
        }
        this.zk.getChildren("/arcus/cache_list/" + this.serviceCode, true, (AsyncCallback.ChildrenCallback)this, null);
    }

    void commandNodeChange(List<String> children) {
        if (children.size() == 0) {
            this.getLogger().error("Cannot find any cache nodes for your service code. Please contact Arcus support to solve this problem. " + this.getInfo());
            children.add(FAKE_SERVER_NODE);
        }
        if (!((Object)children).equals(this.prevChildren)) {
            this.getLogger().warn("Cache list has been changed : From=" + this.prevChildren + ", To=" + children + ", " + this.getInfo());
        }
        this.prevChildren = children;
        this.listener.commandNodeChange(children);
    }

    public void shutdown() {
        this.getLogger().info("Shutting down the CacheMonitor. " + this.getInfo());
        this.dead = true;
        this.listener.closing();
    }

    private String getInfo() {
        String zkSessionId = null;
        if (this.zk != null) {
            zkSessionId = "0x" + Long.toHexString(this.zk.getSessionId());
        }
        return "[serviceCode=" + this.serviceCode + ", adminSessionId=" + zkSessionId + "]";
    }

    public static interface CacheMonitorListener {
        public void commandNodeChange(List<String> var1);

        public void closing();
    }
}

