/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.AdminConnectTimeoutException;
import net.spy.memcached.ArcusClient;
import net.spy.memcached.ArcusClientException;
import net.spy.memcached.CacheMonitor;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.NotExistsServiceCodeException;
import net.spy.memcached.compat.SpyThread;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class CacheManager
extends SpyThread
implements Watcher,
CacheMonitor.CacheMonitorListener {
    public static final String CACHE_LIST_PATH = "/arcus/cache_list/";
    public static final String CLIENT_INFO_PATH = "/arcus/client_list/";
    private static final int SESSION_TIMEOUT = 15000;
    private static final long ZK_CONNECT_TIMEOUT = 5000L;
    private final String hostPort;
    private final String serviceCode;
    private CacheMonitor cacheMonitor;
    private ZooKeeper zk;
    private ArcusClient[] client;
    private final CountDownLatch clientInitLatch;
    private final ConnectionFactoryBuilder cfb;
    private final int waitTimeForConnect;
    private final int poolSize;
    private volatile boolean shutdownRequested = false;
    private CountDownLatch zkInitLatch;

    public CacheManager(String hostPort, String serviceCode, ConnectionFactoryBuilder cfb, CountDownLatch clientInitLatch, int poolSize, int waitTimeForConnect) {
        this.hostPort = hostPort;
        this.serviceCode = serviceCode;
        this.cfb = cfb;
        this.clientInitLatch = clientInitLatch;
        this.poolSize = poolSize;
        this.waitTimeForConnect = waitTimeForConnect;
        this.initZooKeeperClient();
        this.setName("Cache Manager IO for " + serviceCode + "@" + hostPort);
        this.setDaemon(true);
        this.start();
        this.getLogger().info("CacheManager started. (" + serviceCode + "@" + hostPort + ")");
    }

    private void initZooKeeperClient() {
        try {
            this.getLogger().info("Trying to connect to Arcus admin(%s@%s)", this.serviceCode, this.hostPort);
            this.zkInitLatch = new CountDownLatch(1);
            this.zk = new ZooKeeper(this.hostPort, 15000, (Watcher)this);
            try {
                if (!this.zkInitLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                    this.getLogger().fatal("Connecting to Arcus admin(%s) timed out : %d miliseconds", this.hostPort, 5000L);
                    throw new AdminConnectTimeoutException(this.hostPort);
                }
                if (this.zk.exists(CACHE_LIST_PATH + this.serviceCode, false) == null) {
                    this.getLogger().fatal("Service code not found. (" + this.serviceCode + ")");
                    throw new NotExistsServiceCodeException(this.serviceCode);
                }
                String path = this.getClientInfo();
                if (path.isEmpty()) {
                    this.getLogger().fatal("Can't create the znode of client info (" + path + ")");
                    throw new ArcusClientException.InitializeClientException("Can't initialize Arcus client.");
                }
                if (this.zk.exists(path, false) == null) {
                    this.zk.create(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                }
            }
            catch (AdminConnectTimeoutException e) {
                this.shutdownZooKeeperClient();
                throw e;
            }
            catch (NotExistsServiceCodeException e) {
                this.shutdownZooKeeperClient();
                throw e;
            }
            catch (InterruptedException ie) {
                this.getLogger().fatal("Can't connect to Arcus admin(%s@%s) %s", this.serviceCode, this.hostPort, ie.getMessage());
                this.shutdownZooKeeperClient();
                return;
            }
            catch (Exception e) {
                this.getLogger().fatal("Unexpected exception. contact to Arcus administrator");
                this.shutdownZooKeeperClient();
                throw new ArcusClientException.InitializeClientException("Can't initialize Arcus client.", e);
            }
            this.cacheMonitor = new CacheMonitor(this.zk, this.serviceCode, this);
        }
        catch (IOException e) {
            throw new ArcusClientException.InitializeClientException("Can't initialize Arcus client.", e);
        }
    }

    private String getClientInfo() {
        String path = "";
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date currentTime = new Date();
            path = CLIENT_INFO_PATH + this.serviceCode + "/" + InetAddress.getLocalHost().getHostName() + "_" + InetAddress.getLocalHost().getHostAddress() + "_" + this.poolSize + "_java_" + ArcusClient.VERSION + "_" + simpleDateFormat.format(currentTime) + "_" + this.zk.getSessionId();
        }
        catch (UnknownHostException e) {
            return null;
        }
        return path;
    }

    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.None) {
            switch (event.getState()) {
                case SyncConnected: {
                    this.getLogger().info("Connected to Arcus admin. (%s@%s)", this.serviceCode, this.hostPort);
                    this.zkInitLatch.countDown();
                }
            }
        }
        if (this.cacheMonitor != null) {
            this.cacheMonitor.process(event);
        } else {
            this.getLogger().debug("cm is null, servicecode : %s, state:%s, type:%s", this.serviceCode, event.getState(), event.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                while (!this.shutdownRequested) {
                    if (this.zk == null) {
                        this.getLogger().info("Arcus admin connection is not established. (%s@%s)", this.serviceCode, this.hostPort);
                        this.initZooKeeperClient();
                    }
                    if (!this.cacheMonitor.dead) {
                        this.wait();
                        continue;
                    }
                    this.getLogger().warn("Unexpected disconnection from Arcus admin. Trying to reconnect to Arcus admin.");
                    try {
                        this.shutdownZooKeeperClient();
                        this.initZooKeeperClient();
                    }
                    catch (AdminConnectTimeoutException e) {
                        Thread.sleep(5000L);
                    }
                    catch (NotExistsServiceCodeException e) {
                        Thread.sleep(5000L);
                    }
                    catch (ArcusClientException.InitializeClientException e) {
                        Thread.sleep(5000L);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            this.getLogger().warn("current arcus admin is interrupted : %s", e.getMessage());
        }
        finally {
            this.shutdownZooKeeperClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closing() {
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.notifyAll();
        }
    }

    @Override
    public void commandNodeChange(List<String> children) {
        String addrs = "";
        for (int i = 0; i < children.size(); ++i) {
            String[] temp = children.get(i).split("-");
            addrs = i != 0 ? addrs + "," + temp[0] : temp[0];
        }
        if (this.client == null) {
            this.createArcusClient(addrs);
            return;
        }
        for (ArcusClient ac : this.client) {
            MemcachedConnection conn = ac.getMemcachedConnection();
            conn.putMemcachedQueue(addrs);
            conn.getSelector().wakeup();
        }
    }

    private void createArcusClient(String addrs) {
        List<InetSocketAddress> socketList = AddrUtil.getAddresses(addrs);
        final CountDownLatch latch = new CountDownLatch(socketList.size());
        ConnectionObserver observer = new ConnectionObserver(){

            @Override
            public void connectionLost(SocketAddress sa) {
            }

            @Override
            public void connectionEstablished(SocketAddress sa, int reconnectCount) {
                latch.countDown();
            }
        };
        this.cfb.setInitialObservers(Collections.singleton(observer));
        int _awaitTime = 0;
        _awaitTime = this.waitTimeForConnect == 0 ? 50 * socketList.size() : this.waitTimeForConnect;
        this.client = new ArcusClient[this.poolSize];
        for (int i = 0; i < this.poolSize; ++i) {
            try {
                this.client[i] = ArcusClient.getInstance(this.cfb.build(), socketList);
                this.client[i].setName("Memcached IO for " + this.serviceCode);
                this.client[i].setCacheManager(this);
                continue;
            }
            catch (IOException e) {
                this.getLogger().fatal("Arcus Connection has critical problems. contact arcus manager.");
            }
        }
        try {
            if (latch.await(_awaitTime, TimeUnit.MILLISECONDS)) {
                this.getLogger().warn("All arcus connections are established.");
            } else {
                this.getLogger().error("Some arcus connections are not established.");
            }
        }
        catch (InterruptedException e) {
            this.getLogger().fatal("Arcus Connection has critical problems. contact arcus manager.");
        }
        this.clientInitLatch.countDown();
    }

    public ArcusClient[] getAC() {
        return this.client;
    }

    private void shutdownZooKeeperClient() {
        if (this.zk == null) {
            return;
        }
        try {
            this.getLogger().info("Close the ZooKeeper client. serviceCode=" + this.serviceCode + ", adminSessionId=0x" + Long.toHexString(this.zk.getSessionId()));
            this.zk.close();
            this.zk = null;
        }
        catch (InterruptedException e) {
            this.getLogger().warn((Object)"An exception occured while closing ZooKeeper client.", e);
        }
    }

    public void shutdown() {
        if (!this.shutdownRequested) {
            this.getLogger().info("Shut down cache manager.");
            this.shutdownRequested = true;
            this.closing();
        }
    }
}

