/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.MemcachedNodeROImpl;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.util.ArcusKetamaNodeLocatorConfiguration;

public class ArcusKetamaNodeLocator
extends SpyObject
implements NodeLocator {
    TreeMap<Long, MemcachedNode> ketamaNodes;
    Collection<MemcachedNode> allNodes;
    HashAlgorithm hashAlg;
    ArcusKetamaNodeLocatorConfiguration config;
    Lock lock = new ReentrantLock();

    public ArcusKetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg) {
        this(nodes, alg, new ArcusKetamaNodeLocatorConfiguration());
    }

    public ArcusKetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg, ArcusKetamaNodeLocatorConfiguration conf) {
        this.allNodes = nodes;
        this.hashAlg = alg;
        this.ketamaNodes = new TreeMap();
        this.config = conf;
        int numReps = this.config.getNodeRepetitions();
        for (MemcachedNode node : nodes) {
            if (alg == HashAlgorithm.KETAMA_HASH) {
                this.updateHash(node, false);
                continue;
            }
            for (int i = 0; i < numReps; ++i) {
                this.ketamaNodes.put(this.hashAlg.hash(this.config.getKeyForNode(node, i)), node);
            }
        }
        assert (this.ketamaNodes.size() == numReps * nodes.size());
    }

    private ArcusKetamaNodeLocator(TreeMap<Long, MemcachedNode> smn, Collection<MemcachedNode> an, HashAlgorithm alg, ArcusKetamaNodeLocatorConfiguration conf) {
        this.ketamaNodes = smn;
        this.allNodes = an;
        this.hashAlg = alg;
        this.config = conf;
    }

    @Override
    public Collection<MemcachedNode> getAll() {
        return this.allNodes;
    }

    @Override
    public MemcachedNode getPrimary(String k) {
        MemcachedNode rv = this.getNodeForKey(this.hashAlg.hash(k));
        assert (rv != null) : "Found no node for key " + k;
        return rv;
    }

    long getMaxKey() {
        return this.ketamaNodes.lastKey();
    }

    MemcachedNode getNodeForKey(long hash) {
        MemcachedNode rv;
        this.lock.lock();
        try {
            if (!this.ketamaNodes.containsKey(hash)) {
                Long nodeHash = this.ketamaNodes.ceilingKey(hash);
                hash = nodeHash == null ? this.ketamaNodes.firstKey().longValue() : nodeHash.longValue();
            }
            rv = this.ketamaNodes.get(hash);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.lock.unlock();
        }
        return rv;
    }

    @Override
    public Iterator<MemcachedNode> getSequence(String k) {
        return new KetamaIterator(k, this.allNodes.size());
    }

    @Override
    public NodeLocator getReadonlyCopy() {
        TreeMap<Long, MemcachedNode> smn = new TreeMap<Long, MemcachedNode>((SortedMap<Long, MemcachedNode>)this.ketamaNodes);
        ArrayList<MemcachedNode> an = new ArrayList<MemcachedNode>(this.allNodes.size());
        this.lock.lock();
        try {
            for (Map.Entry<Long, MemcachedNode> me : smn.entrySet()) {
                me.setValue(new MemcachedNodeROImpl(me.getValue()));
            }
            for (MemcachedNode n : this.allNodes) {
                an.add(new MemcachedNodeROImpl(n));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.lock.unlock();
        }
        return new ArcusKetamaNodeLocator(smn, an, this.hashAlg, this.config);
    }

    @Override
    public void update(Collection<MemcachedNode> toAttach, Collection<MemcachedNode> toDelete) {
        this.lock.lock();
        try {
            for (MemcachedNode node : toAttach) {
                this.allNodes.add(node);
                this.updateHash(node, false);
            }
            for (MemcachedNode node : toDelete) {
                this.allNodes.remove(node);
                this.updateHash(node, true);
                try {
                    node.getSk().attach(null);
                    node.shutdown();
                }
                catch (IOException e) {
                    this.getLogger().error("Failed to shutdown the node : " + node.toString());
                    node.setSk(null);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    void updateHash(MemcachedNode node, boolean remove) {
        for (int i = 0; i < this.config.getNodeRepetitions() / 4; ++i) {
            byte[] digest = HashAlgorithm.computeMd5(this.config.getKeyForNode(node, i));
            for (int h = 0; h < 4; ++h) {
                Long k = (long)(digest[3 + h * 4] & 0xFF) << 24 | (long)(digest[2 + h * 4] & 0xFF) << 16 | (long)(digest[1 + h * 4] & 0xFF) << 8 | (long)(digest[h * 4] & 0xFF);
                if (remove) {
                    this.ketamaNodes.remove(k);
                    this.config.removeNode(node);
                    continue;
                }
                this.ketamaNodes.put(k, node);
            }
        }
    }

    class KetamaIterator
    implements Iterator<MemcachedNode> {
        final String key;
        long hashVal;
        int remainingTries;
        int numTries = 0;

        public KetamaIterator(String k, int t) {
            this.hashVal = ArcusKetamaNodeLocator.this.hashAlg.hash(k);
            this.remainingTries = t;
            this.key = k;
        }

        private void nextHash() {
            long tmpKey = ArcusKetamaNodeLocator.this.hashAlg.hash(this.numTries++ + this.key);
            this.hashVal += (long)((int)(tmpKey ^ tmpKey >>> 32));
            this.hashVal &= 0xFFFFFFFFL;
            --this.remainingTries;
        }

        @Override
        public boolean hasNext() {
            return this.remainingTries > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MemcachedNode next() {
            try {
                MemcachedNode memcachedNode = ArcusKetamaNodeLocator.this.getNodeForKey(this.hashVal);
                return memcachedNode;
            }
            finally {
                this.nextHash();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

