/*
 * Decompiled with CFR 0.152.
 */
package com.gitegg.platform.mybatis.interceptor;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.gitegg.platform.mybatis.util.SqlInjectionRuleUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.apache.ibatis.exceptions.PersistenceException;

public class GitEggPaginationInnerInterceptor
extends PaginationInnerInterceptor {
    public GitEggPaginationInnerInterceptor(DbType dbType) {
        super.setDbType(dbType);
    }

    public String concatOrderBy(String originalSql, List<OrderItem> orderList) {
        try {
            Select select = (Select)CCJSqlParserUtil.parse((String)originalSql);
            SelectBody selectBody = select.getSelectBody();
            if (selectBody instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)selectBody;
                List orderByElements = plainSelect.getOrderByElements();
                List<OrderByElement> orderByElementsReturn = this.addOrderByElements(orderList, orderByElements);
                plainSelect.setOrderByElements(orderByElementsReturn);
                return select.toString();
            }
            if (selectBody instanceof SetOperationList) {
                SetOperationList setOperationList = (SetOperationList)selectBody;
                List orderByElements = setOperationList.getOrderByElements();
                List<OrderByElement> orderByElementsReturn = this.addOrderByElements(orderList, orderByElements);
                setOperationList.setOrderByElements(orderByElementsReturn);
                return select.toString();
            }
            if (selectBody instanceof WithItem) {
                return originalSql;
            }
            return originalSql;
        }
        catch (JSQLParserException e) {
            this.logger.warn("failed to concat orderBy from IPage, exception:\n" + e.getCause());
            return originalSql;
        }
    }

    protected List<OrderByElement> addOrderByElements(List<OrderItem> orderList, List<OrderByElement> orderByElements) {
        List<OrderByElement> additionalOrderBy = orderList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getColumn())).map(item -> {
            if (SqlInjectionRuleUtils.hasSqlKeyWords(item.getColumn()).booleanValue()) {
                throw new PersistenceException("\u6392\u5e8f\u5b57\u6bb5\u4e2d\u5305\u542bSQL\u5173\u952e\u5b57");
            }
            OrderByElement element = new OrderByElement();
            element.setExpression((Expression)new Column(StringUtils.camelToUnderline((String)item.getColumn())));
            element.setAsc(item.isAsc());
            element.setAscDescPresent(true);
            return element;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderByElements)) {
            return additionalOrderBy;
        }
        additionalOrderBy.addAll(orderByElements);
        return additionalOrderBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitEggPaginationInnerInterceptor)) {
            return false;
        }
        GitEggPaginationInnerInterceptor other = (GitEggPaginationInnerInterceptor)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof GitEggPaginationInnerInterceptor;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "GitEggPaginationInnerInterceptor()";
    }

    public GitEggPaginationInnerInterceptor() {
    }
}

