/*
 * Decompiled with CFR 0.152.
 */
package com.gitegg.platform.mybatis.handler;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import com.gitegg.platform.base.annotation.auth.DataPermission;
import com.gitegg.platform.base.domain.GitEggUser;
import com.gitegg.platform.base.exception.BusinessException;
import com.gitegg.platform.boot.util.GitEggAuthUtils;
import com.gitegg.platform.mybatis.entity.DataPermissionEntity;
import com.gitegg.platform.mybatis.enums.DataPermissionTypeEnum;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class GitEggDataPermissionHandler
implements DataPermissionHandler {
    @Value(value="${tenant.enable}")
    private Boolean enable;
    @Value(value="${data-permission.annotation-enable: false}")
    private Boolean annotationEnable;
    private final RedisTemplate redisTemplate;

    public void processDataPermission(PlainSelect plainSelect, String mappedStatementId) {
        try {
            GitEggUser loginUser = GitEggAuthUtils.getCurrentUser();
            if (ObjectUtils.isNotEmpty((Object)loginUser) && CollectionUtils.isNotEmpty((Collection)loginUser.getDataPermissionTypeList())) {
                StringBuffer statementSb = new StringBuffer();
                if (this.enable.booleanValue()) {
                    statementSb.append("auth:tenant:data:permission:").append(loginUser.getTenantId());
                } else {
                    statementSb.append("auth:data:permission");
                }
                String dataPermissionKey = statementSb.toString();
                StringBuffer statementSbt = new StringBuffer("mapper_");
                statementSbt.append(mappedStatementId).append("_type_");
                String mappedStatementIdKey = statementSbt.toString();
                DataPermissionEntity dataPermissionEntity = null;
                for (String dataPermissionType : loginUser.getDataPermissionTypeList()) {
                    String dataPermissionUserKey = mappedStatementIdKey + dataPermissionType;
                    dataPermissionEntity = (DataPermissionEntity)this.redisTemplate.boundHashOps((Object)dataPermissionKey).get((Object)dataPermissionUserKey);
                    if (!ObjectUtils.isNotEmpty((Object)dataPermissionEntity)) continue;
                    break;
                }
                if (ObjectUtils.isNotEmpty(dataPermissionEntity) && 1 == dataPermissionEntity.getStatus()) {
                    GitEggDataPermissionHandler.dataPermissionFilter(loginUser, dataPermissionEntity, plainSelect);
                } else if (this.annotationEnable.booleanValue()) {
                    Method[] methods;
                    Class<?> clazz = Class.forName(mappedStatementId.substring(0, mappedStatementId.lastIndexOf(".")));
                    String methodName = mappedStatementId.substring(mappedStatementId.lastIndexOf(".") + 1);
                    for (Method method : methods = clazz.getDeclaredMethods()) {
                        DataPermission[] annotations = (DataPermission[])method.getAnnotationsByType(DataPermission.class);
                        if (!ObjectUtils.isNotEmpty((Object)annotations) || !method.getName().equals(methodName)) continue;
                        block4: for (DataPermission dataPermission : annotations) {
                            String dataPermissionType = dataPermission.dataPermissionType();
                            for (String dataPermissionUser : loginUser.getDataPermissionTypeList()) {
                                if (!ObjectUtils.isNotEmpty((Object)dataPermission) || !StringUtils.isNotEmpty((CharSequence)dataPermissionType) || !dataPermissionUser.equals(dataPermissionType)) continue;
                                DataPermissionEntity dataPermissionEntityAnnotation = GitEggDataPermissionHandler.annotationToEntity(dataPermission);
                                GitEggDataPermissionHandler.dataPermissionFilter(loginUser, dataPermissionEntityAnnotation, plainSelect);
                                continue block4;
                            }
                        }
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void dataPermissionFilter(GitEggUser user, DataPermissionEntity dataPermissionEntity, PlainSelect plainSelect) {
        InExpression inExpression;
        Expression expression = plainSelect.getWhere();
        String dataPermissionType = dataPermissionEntity.getDataPermissionType();
        String dataTableName = dataPermissionEntity.getDataTableName();
        String dataTableAlias = dataPermissionEntity.getDataTableAlias();
        String innerTableName = StringUtils.isNotEmpty((CharSequence)dataPermissionEntity.getInnerTableName()) ? dataPermissionEntity.getInnerTableName() : "t_sys_organization";
        String innerTableAlias = StringUtils.isNotEmpty((CharSequence)dataPermissionEntity.getInnerTableAlias()) ? dataPermissionEntity.getInnerTableAlias() : "organizationPermission";
        List organizationIdList = user.getOrganizationIdList();
        String dataColumnExclude = dataPermissionEntity.getDataColumnExclude();
        String dataColumnInclude = dataPermissionEntity.getDataColumnInclude();
        List<Object> includeColumns = new ArrayList();
        List<Object> excludeColumns = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)dataColumnInclude)) {
            includeColumns = Arrays.asList(dataColumnInclude.split(","));
        }
        if (StringUtils.isNotEmpty((CharSequence)dataColumnExclude)) {
            excludeColumns = Arrays.asList(dataColumnExclude.split(","));
        }
        List selectItems = plainSelect.getSelectItems();
        ArrayList<SelectItem> removeItems = new ArrayList<SelectItem>();
        if (CollectionUtils.isNotEmpty((Collection)selectItems) && (CollectionUtils.isNotEmpty(includeColumns) || CollectionUtils.isNotEmpty(excludeColumns))) {
            for (SelectItem selectItem : selectItems) {
                if (selectItem instanceof SelectExpressionItem) {
                    SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                    Alias alias = selectExpressionItem.getAlias();
                    if ((!CollectionUtils.isNotEmpty(includeColumns) || includeColumns.contains(alias.getName())) && (CollectionUtils.isEmpty(excludeColumns) || !excludeColumns.contains(alias.getName()))) continue;
                    removeItems.add(selectItem);
                    continue;
                }
                if (!(selectItem instanceof AllTableColumns)) continue;
                removeItems.add(selectItem);
            }
            if (CollectionUtils.isNotEmpty(removeItems)) {
                selectItems.removeAll(removeItems);
                plainSelect.setSelectItems(selectItems);
            }
        }
        if (DataPermissionTypeEnum.DATA_PERMISSION_ORG_AND_CHILD.getLevel().equals(dataPermissionType)) {
            if (plainSelect.getFromItem() instanceof Table) {
                Table fromTable = (Table)plainSelect.getFromItem();
                Table dataTable = null;
                Table innerTable = null;
                if (fromTable.getName().equalsIgnoreCase(dataTableName)) {
                    dataTable = (Table)plainSelect.getFromItem();
                }
                List joins = plainSelect.getJoins();
                boolean hasPermissionTable = false;
                if (CollectionUtils.isNotEmpty((Collection)joins)) {
                    for (Join join : joins) {
                        FromItem rightItem = join.getRightItem();
                        if (!(rightItem instanceof Table)) continue;
                        Table table = (Table)rightItem;
                        if (null == dataTable && table.getName().equalsIgnoreCase(dataTableName) && null != table.getAlias() && dataTableAlias.equalsIgnoreCase(table.getAlias().getName())) {
                            dataTable = table;
                        }
                        if (!table.getName().equalsIgnoreCase(innerTableName) || null == table.getAlias() || !innerTableAlias.equalsIgnoreCase(table.getAlias().getName())) continue;
                        hasPermissionTable = true;
                        innerTable = table;
                    }
                }
                if (null == dataTable) {
                    throw new BusinessException("\u5728SQL\u8bed\u53e5\u4e2d\u6ca1\u6709\u627e\u5230\u6570\u636e\u6743\u9650\u914d\u7f6e\u7684\u4e3b\u8868\uff0c\u6570\u636e\u6743\u9650\u8fc7\u6ee4\u5931\u8d25\u3002");
                }
                if (!hasPermissionTable) {
                    innerTable = new Table(innerTableName).withAlias(new Alias(innerTableAlias, false));
                    Join join = new Join();
                    join.withRightItem((FromItem)innerTable);
                    EqualsTo equalsTo = new EqualsTo();
                    equalsTo.setLeftExpression((Expression)new Column(dataTable, "t_sys_organization".equalsIgnoreCase(dataTableName) ? "id" : "organization_id"));
                    equalsTo.setRightExpression((Expression)new Column(innerTable, "id"));
                    join.withOnExpression((Expression)equalsTo);
                    plainSelect.addJoins(new Join[]{join});
                }
                EqualsTo equalsToWhere = new EqualsTo();
                equalsToWhere.setLeftExpression((Expression)new Column(innerTable, "id"));
                equalsToWhere.setRightExpression((Expression)new LongValue(user.getOrganizationId().longValue()));
                Function function = new Function();
                function.setName("find_in_set");
                function.setParameters(new ExpressionList(new Expression[]{new LongValue(user.getOrganizationId().longValue()), new Column(innerTable, "ancestors")}));
                OrExpression orExpression = new OrExpression((Expression)equalsToWhere, (Expression)function);
                if (CollectionUtils.isNotEmpty((Collection)organizationIdList)) {
                    for (String organizationId : organizationIdList) {
                        EqualsTo equalsToPermission = new EqualsTo();
                        equalsToPermission.setLeftExpression((Expression)new Column(innerTable, "id"));
                        equalsToPermission.setRightExpression((Expression)new LongValue(organizationId));
                        orExpression = new OrExpression((Expression)orExpression, (Expression)equalsToPermission);
                        Function functionPermission = new Function();
                        functionPermission.setName("find_in_set");
                        functionPermission.setParameters(new ExpressionList(new Expression[]{new LongValue(organizationId), new Column(innerTable, "ancestors")}));
                        orExpression = new OrExpression((Expression)orExpression, (Expression)functionPermission);
                    }
                }
                expression = ObjectUtils.isNotEmpty((Object)expression) ? new AndExpression(expression, (Expression)new Parenthesis((Expression)orExpression)) : orExpression;
                plainSelect.setWhere(expression);
            } else {
                inExpression = new InExpression();
                inExpression.setLeftExpression((Expression)GitEggDataPermissionHandler.buildColumn(dataTableAlias, "t_sys_organization".equalsIgnoreCase(dataTableName) ? "id" : "organization_id"));
                SubSelect subSelect = new SubSelect();
                PlainSelect select = new PlainSelect();
                select.setSelectItems(Collections.singletonList(new SelectExpressionItem((Expression)new Column("id"))));
                select.setFromItem((FromItem)new Table("t_sys_organization"));
                EqualsTo equalsTo = new EqualsTo();
                equalsTo.setLeftExpression((Expression)new Column("id"));
                equalsTo.setRightExpression((Expression)new LongValue(user.getOrganizationId().longValue()));
                Function function = new Function();
                function.setName("find_in_set");
                function.setParameters(new ExpressionList(new Expression[]{new LongValue(user.getOrganizationId().longValue()), new Column("ancestors")}));
                OrExpression orExpression = new OrExpression((Expression)equalsTo, (Expression)function);
                if (CollectionUtils.isNotEmpty((Collection)organizationIdList)) {
                    for (String organizationId : organizationIdList) {
                        EqualsTo equalsToPermission = new EqualsTo();
                        equalsToPermission.setLeftExpression((Expression)new Column("id"));
                        equalsToPermission.setRightExpression((Expression)new LongValue(organizationId));
                        orExpression = new OrExpression((Expression)orExpression, (Expression)equalsToPermission);
                        Function functionPermission = new Function();
                        functionPermission.setName("find_in_set");
                        functionPermission.setParameters(new ExpressionList(new Expression[]{new LongValue(organizationId), new Column("ancestors")}));
                        orExpression = new OrExpression((Expression)orExpression, (Expression)functionPermission);
                    }
                }
                select.setWhere((Expression)orExpression);
                subSelect.setSelectBody((SelectBody)select);
                inExpression.setRightExpression((Expression)subSelect);
                expression = ObjectUtils.isNotEmpty((Object)expression) ? new AndExpression(expression, (Expression)new Parenthesis((Expression)inExpression)) : inExpression;
                plainSelect.setWhere(expression);
            }
        } else if (DataPermissionTypeEnum.DATA_PERMISSION_ORG.getLevel().equals(dataPermissionType)) {
            inExpression = new InExpression();
            inExpression.setLeftExpression((Expression)GitEggDataPermissionHandler.buildColumn(dataTableAlias, "t_sys_organization".equalsIgnoreCase(dataTableName) ? "id" : "organization_id"));
            ExpressionList expressionList = new ExpressionList();
            ArrayList<LongValue> expressions = new ArrayList<LongValue>();
            expressions.add(new LongValue(user.getOrganizationId().longValue()));
            if (CollectionUtils.isNotEmpty((Collection)organizationIdList)) {
                for (String organizationId : organizationIdList) {
                    expressions.add(new LongValue(organizationId));
                }
            }
            expressionList.setExpressions(expressions);
            inExpression.setRightItemsList((ItemsList)expressionList);
            expression = ObjectUtils.isNotEmpty((Object)expression) ? new AndExpression(expression, (Expression)new Parenthesis((Expression)inExpression)) : inExpression;
            plainSelect.setWhere(expression);
        } else if (DataPermissionTypeEnum.DATA_PERMISSION_SELF.getLevel().equals(dataPermissionType)) {
            EqualsTo equalsTo = new EqualsTo();
            equalsTo.setLeftExpression((Expression)GitEggDataPermissionHandler.buildColumn(dataTableAlias, "creator"));
            equalsTo.setRightExpression((Expression)new StringValue(String.valueOf(user.getId())));
            expression = ObjectUtils.isNotEmpty((Object)expression) ? new AndExpression(expression, (Expression)new Parenthesis((Expression)equalsTo)) : equalsTo;
            plainSelect.setWhere(expression);
        } else if (DataPermissionTypeEnum.DATA_PERMISSION_CUSTOM.getLevel().equals(dataPermissionType)) {
            String customExpression = dataPermissionEntity.getCustomExpression();
            if (StringUtils.isEmpty((CharSequence)customExpression)) {
                throw new BusinessException("\u6ca1\u6709\u914d\u7f6e\u81ea\u5b9a\u4e49\u8868\u8fbe\u5f0f");
            }
            try {
                Expression expressionCustom = CCJSqlParserUtil.parseCondExpression((String)customExpression);
                expression = ObjectUtils.isNotEmpty((Object)expression) ? new AndExpression(expression, (Expression)new Parenthesis(expressionCustom)) : expressionCustom;
                plainSelect.setWhere(expression);
            }
            catch (JSQLParserException e) {
                throw new BusinessException("\u81ea\u5b9a\u4e49\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef");
            }
        }
    }

    public static Column buildColumn(String dataTableAlias, String columnName) {
        if (StringUtils.isNotEmpty((CharSequence)dataTableAlias)) {
            columnName = dataTableAlias + "." + columnName;
        }
        return new Column(columnName);
    }

    public static DataPermissionEntity annotationToEntity(DataPermission annotation) {
        DataPermissionEntity dataPermissionEntity = new DataPermissionEntity();
        dataPermissionEntity.setDataPermissionType(annotation.dataPermissionType());
        dataPermissionEntity.setDataColumnExclude(annotation.dataColumnExclude());
        dataPermissionEntity.setDataColumnInclude(annotation.dataColumnInclude());
        dataPermissionEntity.setDataTableName(annotation.dataTableName());
        dataPermissionEntity.setDataTableAlias(annotation.dataTableAlias());
        dataPermissionEntity.setInnerTableName(annotation.innerTableName());
        dataPermissionEntity.setInnerTableAlias(annotation.innerTableAlias());
        dataPermissionEntity.setCustomExpression(annotation.customExpression());
        return dataPermissionEntity;
    }

    public Expression getSqlSegment(Expression where, String mappedStatementId) {
        return null;
    }

    @Autowired
    public GitEggDataPermissionHandler(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

