/*
 * Decompiled with CFR 0.152.
 */
package com.gitegg.platform.mybatis.config;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.gitegg.platform.boot.util.GitEggAuthUtils;
import com.gitegg.platform.mybatis.config.MybatisPlusConfig;
import com.gitegg.platform.mybatis.props.TenantProperties;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={MybatisPlusConfig.class})
public class TenantConfig {
    private final TenantProperties tenantProperties;

    @Bean
    public TenantLineInnerInterceptor tenantLineInnerInterceptor() {
        return new TenantLineInnerInterceptor(new TenantLineHandler(){

            public Expression getTenantId() {
                String tenant = GitEggAuthUtils.getTenantId();
                if (tenant != null) {
                    return new StringValue(GitEggAuthUtils.getTenantId());
                }
                return new NullValue();
            }

            public String getTenantIdColumn() {
                return TenantConfig.this.tenantProperties.getColumn();
            }

            public boolean ignoreTable(String tableName) {
                return TenantConfig.this.tenantProperties.getExclusionTable().stream().anyMatch(t -> t.equalsIgnoreCase(tableName));
            }
        });
    }

    @Autowired
    public TenantConfig(TenantProperties tenantProperties) {
        this.tenantProperties = tenantProperties;
    }
}

