/*
 * Decompiled with CFR 0.152.
 */
package com.gitegg.platform.mybatis.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.gitegg.platform.mybatis.handler.GitEggDataPermissionHandler;
import com.gitegg.platform.mybatis.interceptor.GitEggDataPermissionInterceptor;
import com.gitegg.platform.mybatis.interceptor.GitEggPaginationInnerInterceptor;
import com.gitegg.platform.mybatis.props.TenantProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisPlusConfig {
    private final TenantLineInnerInterceptor tenantLineInnerInterceptor;
    private final GitEggDataPermissionHandler gitEggDataPermissionHandler;
    private final TenantProperties tenantProperties;

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        if (this.tenantProperties.getEnable().booleanValue()) {
            interceptor.addInnerInterceptor((InnerInterceptor)this.tenantLineInnerInterceptor);
        }
        interceptor.addInnerInterceptor((InnerInterceptor)new GitEggDataPermissionInterceptor(this.gitEggDataPermissionHandler));
        interceptor.addInnerInterceptor((InnerInterceptor)new GitEggPaginationInnerInterceptor(DbType.MYSQL));
        BlockAttackInnerInterceptor blockAttackInnerInterceptor = new BlockAttackInnerInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)blockAttackInnerInterceptor);
        return interceptor;
    }

    @Bean
    public OptimisticLockerInnerInterceptor optimisticLockerInterceptor() {
        return new OptimisticLockerInnerInterceptor();
    }

    @Autowired
    public MybatisPlusConfig(TenantLineInnerInterceptor tenantLineInnerInterceptor, GitEggDataPermissionHandler gitEggDataPermissionHandler, TenantProperties tenantProperties) {
        this.tenantLineInnerInterceptor = tenantLineInnerInterceptor;
        this.gitEggDataPermissionHandler = gitEggDataPermissionHandler;
        this.tenantProperties = tenantProperties;
    }
}

