/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.TemporalAccessorUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.TimeZone;

public class LocalDateTimeUtil {
    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDateTime of(Instant instant) {
        return LocalDateTimeUtil.of(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime ofUTC(Instant instant) {
        return LocalDateTimeUtil.of(instant, ZoneId.of("UTC"));
    }

    public static LocalDateTime of(ZonedDateTime zonedDateTime) {
        if (null == zonedDateTime) {
            return null;
        }
        return zonedDateTime.toLocalDateTime();
    }

    public static LocalDateTime of(Instant instant, ZoneId zoneId) {
        if (null == instant) {
            return null;
        }
        return LocalDateTime.ofInstant(instant, ObjectUtil.defaultIfNull(zoneId, ZoneId.systemDefault()));
    }

    public static LocalDateTime of(Instant instant, TimeZone timeZone) {
        if (null == instant) {
            return null;
        }
        return LocalDateTimeUtil.of(instant, ObjectUtil.defaultIfNull(timeZone, TimeZone.getDefault()).toZoneId());
    }

    public static LocalDateTime of(long epochMilli) {
        return LocalDateTimeUtil.of(Instant.ofEpochMilli(epochMilli));
    }

    public static LocalDateTime ofUTC(long epochMilli) {
        return LocalDateTimeUtil.ofUTC(Instant.ofEpochMilli(epochMilli));
    }

    public static LocalDateTime of(long epochMilli, ZoneId zoneId) {
        return LocalDateTimeUtil.of(Instant.ofEpochMilli(epochMilli), zoneId);
    }

    public static LocalDateTime of(long epochMilli, TimeZone timeZone) {
        return LocalDateTimeUtil.of(Instant.ofEpochMilli(epochMilli), timeZone);
    }

    public static LocalDateTime of(Date date) {
        if (null == date) {
            return null;
        }
        if (date instanceof DateTime) {
            return LocalDateTimeUtil.of(date.toInstant(), ((DateTime)date).getZoneId());
        }
        return LocalDateTimeUtil.of(date.toInstant());
    }

    public static LocalDateTime of(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDate) {
            return ((LocalDate)temporalAccessor).atStartOfDay();
        }
        return LocalDateTime.of(TemporalAccessorUtil.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.DAY_OF_MONTH), TemporalAccessorUtil.get(temporalAccessor, ChronoField.HOUR_OF_DAY), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.SECOND_OF_MINUTE), TemporalAccessorUtil.get(temporalAccessor, ChronoField.NANO_OF_SECOND));
    }

    public static LocalDate ofDate(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).toLocalDate();
        }
        return LocalDate.of(TemporalAccessorUtil.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.DAY_OF_MONTH));
    }

    public static LocalDateTime parse(CharSequence text) {
        return LocalDateTimeUtil.parse(text, (DateTimeFormatter)null);
    }

    public static LocalDateTime parse(CharSequence text, DateTimeFormatter formatter) {
        if (null == text) {
            return null;
        }
        if (null == formatter) {
            return LocalDateTime.parse(text);
        }
        return LocalDateTimeUtil.of(formatter.parse(text));
    }

    public static LocalDateTime parse(CharSequence text, String format) {
        if (null == text) {
            return null;
        }
        DateTimeFormatter formatter = null;
        if (StrUtil.isNotBlank(format)) {
            if (StrUtil.startWithIgnoreEquals(format, "yyyyMMddHHmmss")) {
                String fraction = StrUtil.removePrefix(format, "yyyyMMddHHmmss");
                if (ReUtil.isMatch("[S]{1,2}", (CharSequence)fraction)) {
                    text = text + StrUtil.repeat('0', 3 - fraction.length());
                }
                formatter = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
            } else {
                formatter = DateTimeFormatter.ofPattern(format);
            }
        }
        return LocalDateTimeUtil.parse(text, formatter);
    }

    public static LocalDate parseDate(CharSequence text) {
        return LocalDateTimeUtil.parseDate(text, (DateTimeFormatter)null);
    }

    public static LocalDate parseDate(CharSequence text, DateTimeFormatter formatter) {
        if (null == text) {
            return null;
        }
        if (null == formatter) {
            return LocalDate.parse(text);
        }
        return LocalDateTimeUtil.ofDate(formatter.parse(text));
    }

    public static LocalDate parseDate(CharSequence text, String format) {
        if (null == text) {
            return null;
        }
        return LocalDateTimeUtil.parseDate(text, DateTimeFormatter.ofPattern(format));
    }

    public static String formatNormal(LocalDateTime time) {
        return LocalDateTimeUtil.format(time, DatePattern.NORM_DATETIME_FORMATTER);
    }

    public static String format(LocalDateTime time, DateTimeFormatter formatter) {
        return TemporalAccessorUtil.format((TemporalAccessor)time, formatter);
    }

    public static String format(LocalDateTime time, String format) {
        if (null == time) {
            return null;
        }
        return LocalDateTimeUtil.format(time, DateTimeFormatter.ofPattern(format));
    }

    public static String formatNormal(LocalDate date) {
        return LocalDateTimeUtil.format(date, DatePattern.NORM_DATE_FORMATTER);
    }

    public static String format(LocalDate date, DateTimeFormatter formatter) {
        return TemporalAccessorUtil.format((TemporalAccessor)date, formatter);
    }

    public static String format(LocalDate date, String format) {
        if (null == date) {
            return null;
        }
        return LocalDateTimeUtil.format(date, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDateTime offset(LocalDateTime time, long number, TemporalUnit field) {
        if (null == time) {
            return null;
        }
        return time.plus(number, field);
    }

    public static Duration between(LocalDateTime startTime, LocalDateTime endTime) {
        return Duration.between(startTime, endTime);
    }

    public static LocalDateTime beginOfDay(LocalDateTime time) {
        return time.with(LocalTime.of(0, 0, 0, 0));
    }

    public static LocalDateTime endOfDay(LocalDateTime time) {
        return time.with(LocalTime.of(23, 59, 59, 999999999));
    }

    public static long toEpochMilli(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtil.toEpochMilli(temporalAccessor);
    }
}

