/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Objects;
import org.springframework.lang.Contract;
import org.springframework.util.ObjectUtils;

public class ExpirationOptions {
    private static final ExpirationOptions NONE = new ExpirationOptions(Condition.ALWAYS);
    private final Condition condition;

    ExpirationOptions(Condition condition) {
        this.condition = condition;
    }

    public static ExpirationOptions none() {
        return NONE;
    }

    public static ExpirationOptionsBuilder builder() {
        return new ExpirationOptionsBuilder();
    }

    public Condition getCondition() {
        return this.condition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpirationOptions that = (ExpirationOptions)o;
        return ObjectUtils.nullSafeEquals((Object)((Object)this.condition), (Object)((Object)that.condition));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.condition});
    }

    public static enum Condition {
        ALWAYS,
        NX,
        XX,
        GT,
        LT;

    }

    public static class ExpirationOptionsBuilder {
        private Condition condition = Condition.ALWAYS;

        private ExpirationOptionsBuilder() {
        }

        @Contract(value="-> this")
        public ExpirationOptionsBuilder nx() {
            this.condition = Condition.NX;
            return this;
        }

        @Contract(value="-> this")
        public ExpirationOptionsBuilder xx() {
            this.condition = Condition.XX;
            return this;
        }

        @Contract(value="-> this")
        public ExpirationOptionsBuilder gt() {
            this.condition = Condition.GT;
            return this;
        }

        @Contract(value="-> this")
        public ExpirationOptionsBuilder lt() {
            this.condition = Condition.LT;
            return this;
        }

        public ExpirationOptions build() {
            return this.condition == Condition.ALWAYS ? NONE : new ExpirationOptions(this.condition);
        }
    }
}

