/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ReproducibleResourceTransformer;

public class PropertiesMergingResourceTransformer
implements ReproducibleResourceTransformer {
    private String resource;
    private final Properties data = new Properties();
    private long time;

    public Properties getData() {
        return this.data;
    }

    public boolean canTransformResource(String resource) {
        return this.resource != null && this.resource.equalsIgnoreCase(resource);
    }

    @Deprecated
    public void processResource(String resource, InputStream inputStream, List<Relocator> relocators) throws IOException {
        this.processResource(resource, inputStream, relocators, 0L);
    }

    public void processResource(String resource, InputStream inputStream, List<Relocator> relocators, long time) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        inputStream.close();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> this.process((String)name, (String)value)));
        if (time > this.time) {
            this.time = time;
        }
    }

    private void process(String name, String value) {
        String existing = this.data.getProperty(name);
        this.data.setProperty(name, existing != null ? existing + "," + value : value);
    }

    public boolean hasTransformedResource() {
        return !this.data.isEmpty();
    }

    public void modifyOutputStream(JarOutputStream os) throws IOException {
        JarEntry jarEntry = new JarEntry(this.resource);
        jarEntry.setTime(this.time);
        os.putNextEntry(jarEntry);
        this.data.store(os, "Merged by PropertiesMergingResourceTransformer");
        os.flush();
        this.data.clear();
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

