/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import jodd.lagarto.LagartoParser;
import jodd.lagarto.dom.DOMBuilder;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.LagartoDOMBuilderTagVisitor;
import jodd.lagarto.dom.LagartoNodeHtmlRenderer;
import jodd.util.StringUtil;

public class LagartoDOMBuilder
implements DOMBuilder {
    public static final String[] HTML5_VOID_TAGS = new String[]{"area", "base", "br", "col", "embed", "hr", "img", "input", "keygen", "link", "menuitem", "meta", "param", "source", "track", "wbr"};
    protected boolean parseSpecialTagsAsCdata;
    protected boolean enableConditionalComments;
    protected boolean calculatePosition;
    protected boolean ignoreWhitespacesBetweenTags;
    protected boolean caseSensitive;
    protected boolean ignoreComments;
    protected boolean selfCloseVoidTags;
    protected boolean collectErrors;
    protected String conditionalCommentExpression;
    protected String[] voidTags = HTML5_VOID_TAGS;
    protected boolean impliedEndTags;
    protected LagartoNodeHtmlRenderer renderer = new LagartoNodeHtmlRenderer();
    protected int parsingErrorLogLevel = 4;
    protected boolean useFosterRules;
    protected boolean unclosedTagAsOrphanCheck;

    public LagartoDOMBuilder() {
        this.enableHtmlMode();
    }

    public boolean isUnclosedTagAsOrphanCheck() {
        return this.unclosedTagAsOrphanCheck;
    }

    public LagartoDOMBuilder setUnclosedTagAsOrphanCheck(boolean unclosedTagAsOrphanCheck) {
        this.unclosedTagAsOrphanCheck = unclosedTagAsOrphanCheck;
        return this;
    }

    public boolean isUseFosterRules() {
        return this.useFosterRules;
    }

    public LagartoDOMBuilder setUseFosterRules(boolean useFosterRules) {
        this.useFosterRules = useFosterRules;
        return this;
    }

    public boolean isParseSpecialTagsAsCdata() {
        return this.parseSpecialTagsAsCdata;
    }

    public LagartoDOMBuilder setParseSpecialTagsAsCdata(boolean parseSpecialTagsAsCdata) {
        this.parseSpecialTagsAsCdata = parseSpecialTagsAsCdata;
        return this;
    }

    public boolean isEnableConditionalComments() {
        return this.enableConditionalComments;
    }

    public LagartoDOMBuilder setEnableConditionalComments(boolean enableConditionalComments) {
        this.enableConditionalComments = enableConditionalComments;
        return this;
    }

    public boolean isCalculatePosition() {
        return this.calculatePosition;
    }

    public LagartoDOMBuilder setCalculatePosition(boolean calculatePosition) {
        this.calculatePosition = calculatePosition;
        return this;
    }

    public LagartoNodeHtmlRenderer getRenderer() {
        return this.renderer;
    }

    public LagartoDOMBuilder setRenderer(LagartoNodeHtmlRenderer renderer) {
        this.renderer = renderer;
        return this;
    }

    public boolean isIgnoreWhitespacesBetweenTags() {
        return this.ignoreWhitespacesBetweenTags;
    }

    public LagartoDOMBuilder setIgnoreWhitespacesBetweenTags(boolean ignoreWhitespacesBetweenTags) {
        this.ignoreWhitespacesBetweenTags = ignoreWhitespacesBetweenTags;
        return this;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public LagartoDOMBuilder setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public LagartoDOMBuilder setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
        return this;
    }

    public String[] getVoidTags() {
        return this.voidTags;
    }

    public LagartoDOMBuilder setVoidTags(String ... voidTags) {
        this.voidTags = voidTags;
        return this;
    }

    public boolean hasVoidTags() {
        return this.voidTags != null;
    }

    public boolean isVoidTag(String tagName) {
        if (this.voidTags == null) {
            return false;
        }
        return StringUtil.equalsOne((String)(tagName = tagName.toLowerCase()), (String[])this.voidTags) != -1;
    }

    public boolean isSelfCloseVoidTags() {
        return this.selfCloseVoidTags;
    }

    public LagartoDOMBuilder setSelfCloseVoidTags(boolean selfCloseVoidTags) {
        this.selfCloseVoidTags = selfCloseVoidTags;
        return this;
    }

    public boolean isCollectErrors() {
        return this.collectErrors;
    }

    public LagartoDOMBuilder setCollectErrors(boolean collectErrors) {
        this.collectErrors = collectErrors;
        return this;
    }

    public String getConditionalCommentExpression() {
        return this.conditionalCommentExpression;
    }

    public LagartoDOMBuilder setConditionalCommentExpression(String conditionalCommentExpression) {
        this.conditionalCommentExpression = conditionalCommentExpression;
        return this;
    }

    public boolean isImpliedEndTags() {
        return this.impliedEndTags;
    }

    public LagartoDOMBuilder setImpliedEndTags(boolean impliedEndTags) {
        this.impliedEndTags = impliedEndTags;
        return this;
    }

    public int getParsingErrorLogLevel() {
        return this.parsingErrorLogLevel;
    }

    public void setParsingErrorLogLevelName(String logLevel) {
        if ((logLevel = logLevel.trim().toUpperCase()).equals("ERROR")) {
            this.parsingErrorLogLevel = 5;
        } else if (logLevel.equals("WARN")) {
            this.parsingErrorLogLevel = 4;
        } else if (logLevel.equals("INFO")) {
            this.parsingErrorLogLevel = 3;
        } else if (logLevel.equals("DEBUG")) {
            this.parsingErrorLogLevel = 2;
        } else if (logLevel.equals("TRACE")) {
            this.parsingErrorLogLevel = 1;
        }
    }

    public LagartoDOMBuilder enableDebug() {
        this.collectErrors = true;
        this.calculatePosition = true;
        return this;
    }

    public LagartoDOMBuilder disableDebug() {
        this.collectErrors = false;
        this.calculatePosition = false;
        return this;
    }

    public LagartoDOMBuilder enableHtmlPlusMode() {
        this.enableHtmlMode();
        this.useFosterRules = true;
        this.unclosedTagAsOrphanCheck = true;
        return this;
    }

    public LagartoDOMBuilder enableHtmlMode() {
        this.ignoreWhitespacesBetweenTags = false;
        this.caseSensitive = false;
        this.parseSpecialTagsAsCdata = true;
        this.voidTags = HTML5_VOID_TAGS;
        this.selfCloseVoidTags = false;
        this.impliedEndTags = true;
        this.enableConditionalComments = true;
        this.conditionalCommentExpression = "if !IE";
        this.renderer.reset();
        return this;
    }

    public LagartoDOMBuilder enableXhtmlMode() {
        this.ignoreWhitespacesBetweenTags = false;
        this.caseSensitive = true;
        this.parseSpecialTagsAsCdata = false;
        this.voidTags = HTML5_VOID_TAGS;
        this.selfCloseVoidTags = true;
        this.impliedEndTags = false;
        this.enableConditionalComments = true;
        this.conditionalCommentExpression = "if !IE";
        this.renderer.reset();
        return this;
    }

    public LagartoDOMBuilder enableXmlMode() {
        this.ignoreWhitespacesBetweenTags = true;
        this.caseSensitive = true;
        this.parseSpecialTagsAsCdata = false;
        this.voidTags = null;
        this.selfCloseVoidTags = false;
        this.impliedEndTags = false;
        this.enableConditionalComments = false;
        this.conditionalCommentExpression = null;
        this.renderer.reset();
        return this;
    }

    public Document parse(char[] content) {
        LagartoParser lagartoParser = new LagartoParser(content);
        return this.doParse(lagartoParser);
    }

    public Document parse(String content) {
        LagartoParser lagartoParser = new LagartoParser(content);
        return this.doParse(lagartoParser);
    }

    protected Document doParse(LagartoParser lagartoParser) {
        lagartoParser.setParseSpecialTagsAsCdata(this.parseSpecialTagsAsCdata);
        lagartoParser.setEnableConditionalComments(this.enableConditionalComments);
        lagartoParser.setCalculatePosition(this.calculatePosition);
        LagartoDOMBuilderTagVisitor domBuilderTagVisitor = new LagartoDOMBuilderTagVisitor(this);
        lagartoParser.parse(domBuilderTagVisitor);
        return domBuilderTagVisitor.getDocument();
    }
}

