/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.context;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.as.security.SecurityMessages;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

class SecurityActions {
    SecurityActions() {
    }

    static ModuleClassLoader getModuleClassLoader() throws ModuleLoadException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ModuleClassLoader>(){

                    @Override
                    public ModuleClassLoader run() throws ModuleLoadException {
                        ModuleLoader loader = Module.getCallerModuleLoader();
                        ModuleIdentifier identifier = ModuleIdentifier.create((String)"org.jboss.as.security", (String)"main");
                        return loader.loadModule(identifier).getClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw SecurityMessages.MESSAGES.moduleLoadException(pae);
            }
        }
        ModuleLoader loader = Module.getCallerModuleLoader();
        ModuleIdentifier identifier = ModuleIdentifier.create((String)"org.jboss.as.security", (String)"main");
        return loader.loadModule(identifier).getClassLoader();
    }
}

