/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.kafka;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.springframework.kafka.listener.MessageListener;

public class KafkaChannelMessageListenerAdapter
implements MessageListener<String, String> {
    protected EventRegistry eventRegistry;
    protected InboundChannelModel inboundChannelModel;

    public KafkaChannelMessageListenerAdapter(EventRegistry eventRegistry, InboundChannelModel inboundChannelModel) {
        this.eventRegistry = eventRegistry;
        this.inboundChannelModel = inboundChannelModel;
    }

    public void onMessage(ConsumerRecord<String, String> data) {
        this.eventRegistry.eventReceived(this.inboundChannelModel, (String)data.value());
    }

    public EventRegistry getEventRegistry() {
        return this.eventRegistry;
    }

    public void setEventRegistry(EventRegistry eventRegistry) {
        this.eventRegistry = eventRegistry;
    }

    public InboundChannelModel getInboundChannelModel() {
        return this.inboundChannelModel;
    }

    public void setInboundChannelModel(InboundChannelModel inboundChannelModel) {
        this.inboundChannelModel = inboundChannelModel;
    }
}

