/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.temporal.ChronoField;
import java.time.temporal.ValueRange;
import java.util.function.Supplier;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.exparity.hamcrest.date.core.format.DatePartFormatter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsMinimum<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final ChronoField datePart;
    private final TemporalAdapter<T> adapter;
    private final DatePartFormatter formatter;
    private final Supplier<String> descriptionSupplier;

    public IsMinimum(ChronoField datePart, TemporalAdapter<T> adapter, DatePartFormatter formatter, Supplier<String> descriptionSupplier) {
        this.datePart = datePart;
        this.adapter = adapter;
        this.formatter = formatter;
        this.descriptionSupplier = descriptionSupplier;
    }

    public IsMinimum(ChronoField datePart, TemporalAdapter<T> adapter, DatePartFormatter formatter) {
        this(datePart, adapter, formatter, () -> "the date is the minimum value for " + formatter.describe(datePart));
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        long actualValue = this.datePart.getFrom(this.adapter.asTemporal(actual));
        ValueRange range = this.datePart.rangeRefinedBy(this.adapter.asTemporal(actual));
        if (range.getMinimum() != actualValue) {
            mismatchDesc.appendText("date is the " + actualValue + " " + this.formatter.describe(this.datePart) + " instead of " + range.getMinimum() + " " + this.formatter.describe(this.datePart));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(this.descriptionSupplier.get());
    }
}

