/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric;

import java.io.Serializable;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.asymmetric.KeyType;

public class BaseAsymmetric<T extends BaseAsymmetric<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String algorithm;
    protected Lock lock = new ReentrantLock();
    protected PublicKey publicKey;
    protected PrivateKey privateKey;

    public BaseAsymmetric(String algorithm, KeyPair keyPair) {
        this.init(algorithm, keyPair);
    }

    protected T init(String algorithm, KeyPair keyPair) {
        this.algorithm = algorithm;
        PrivateKey privateKey = (PrivateKey)ObjUtil.apply((Object)keyPair, KeyPair::getPrivate);
        PublicKey publicKey = (PublicKey)ObjUtil.apply((Object)keyPair, KeyPair::getPublic);
        if (null == privateKey && null == publicKey) {
            this.initKeys();
        } else {
            if (null != privateKey) {
                this.privateKey = privateKey;
            }
            if (null != publicKey) {
                this.publicKey = publicKey;
            }
        }
        return (T)this;
    }

    public T initKeys() {
        KeyPair keyPair = KeyUtil.generateKeyPair(this.algorithm);
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
        return (T)this;
    }

    public T setLock(Lock lock) {
        this.lock = lock;
        return (T)this;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getPublicKeyBase64() {
        PublicKey publicKey = this.getPublicKey();
        return null == publicKey ? null : Base64.encode((byte[])publicKey.getEncoded());
    }

    public T setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return (T)this;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getPrivateKeyBase64() {
        PrivateKey privateKey = this.getPrivateKey();
        return null == privateKey ? null : Base64.encode((byte[])privateKey.getEncoded());
    }

    public T setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return (T)this;
    }

    public T setKey(Key key) {
        Assert.notNull((Object)key, (String)"key must be not null !", (Object[])new Object[0]);
        if (key instanceof PublicKey) {
            return this.setPublicKey((PublicKey)key);
        }
        if (key instanceof PrivateKey) {
            return this.setPrivateKey((PrivateKey)key);
        }
        throw new CryptoException("Unsupported key type: {}", key.getClass());
    }

    protected Key getKeyByType(KeyType type) {
        switch (type) {
            case PrivateKey: {
                if (null == this.privateKey) {
                    throw new NullPointerException("Private key must not null when use it !");
                }
                return this.privateKey;
            }
            case PublicKey: {
                if (null == this.publicKey) {
                    throw new NullPointerException("Public key must not null when use it !");
                }
                return this.publicKey;
            }
        }
        throw new CryptoException("Unsupported key type: " + (Object)((Object)type));
    }
}

