/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.engine.AbstractJSONEngine;
import org.dromara.hutool.json.engine.JSONEngineConfig;

public class JacksonEngine
extends AbstractJSONEngine {
    private ObjectMapper mapper;

    public JacksonEngine() {
        Assert.notNull(ObjectMapper.class);
    }

    @Override
    public void serialize(Object bean, Writer writer) {
        this.initEngine();
        try {
            this.mapper.writeValue(writer, bean);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public <T> T deserialize(Reader reader, Object type) {
        this.initEngine();
        try {
            if (type instanceof Class) {
                return (T)this.mapper.readValue(reader, (Class)type);
            }
            if (type instanceof TypeReference) {
                return (T)this.mapper.readValue(reader, (TypeReference)type);
            }
            if (type instanceof JavaType) {
                return (T)this.mapper.readValue(reader, (JavaType)type);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        throw new JSONException("Unsupported type: {}", type.getClass());
    }

    @Override
    protected void reset() {
        this.mapper = null;
    }

    @Override
    protected void initEngine() {
        if (null != this.mapper) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES, JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES});
        if (ObjUtil.defaultIfNull(this.config, JSONEngineConfig::isPrettyPrint, false).booleanValue()) {
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        this.mapper = mapper;
    }
}

