/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.engine.AbstractJSONEngine;
import org.dromara.hutool.json.engine.JSONEngineConfig;

public class GsonEngine
extends AbstractJSONEngine {
    private Gson gson;

    public GsonEngine() {
        Assert.notNull(Gson.class);
    }

    @Override
    public void serialize(Object bean, Writer writer) {
        this.initEngine();
        this.gson.toJson(bean, (Appendable)writer);
    }

    @Override
    public <T> T deserialize(Reader reader, Object type) {
        this.initEngine();
        if (type instanceof Class) {
            return (T)this.gson.fromJson(reader, (Class)type);
        }
        if (type instanceof Type) {
            return (T)this.gson.fromJson(reader, (Type)type);
        }
        throw new JSONException("Unsupported type: {}", type.getClass());
    }

    @Override
    protected void reset() {
        this.gson = null;
    }

    @Override
    protected void initEngine() {
        if (null != this.gson) {
            return;
        }
        GsonBuilder builder = new GsonBuilder();
        if (ObjUtil.defaultIfNull(this.config, JSONEngineConfig::isPrettyPrint, false).booleanValue()) {
            builder.setPrettyPrinting();
        }
        this.gson = builder.create();
    }
}

