/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.driver.matcher;

import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.db.driver.matcher.DriverMatcher;

public class MysqlDriverMatcher
implements DriverMatcher {
    private final ClassLoader classLoader;
    private Boolean isVersion6;

    public MysqlDriverMatcher(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public boolean test(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:mysql:") || jdbcUrl.startsWith("jdbc:cobar:") || jdbcUrl.startsWith("jdbc:log4jdbc:mysql:");
    }

    @Override
    public String getClassName() {
        String driverNameV6 = "com.mysql.cj.jdbc.Driver";
        if (this.isVersion6 == null) {
            this.isVersion6 = ClassLoaderUtil.isPresent("com.mysql.cj.jdbc.Driver", this.classLoader);
        }
        return this.isVersion6 != false ? "com.mysql.cj.jdbc.Driver" : "com.mysql.jdbc.Driver";
    }
}

