/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric;

import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.io.stream.FastByteArrayOutputStream;
import org.dromara.hutool.crypto.Cipher;
import org.dromara.hutool.crypto.CipherMode;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.JceCipher;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.asymmetric.AbstractAsymmetricCrypto;
import org.dromara.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import org.dromara.hutool.crypto.asymmetric.KeyType;

public class AsymmetricCrypto
extends AbstractAsymmetricCrypto<AsymmetricCrypto> {
    private static final long serialVersionUID = 1L;
    protected Cipher cipher;
    protected int encryptBlockSize = -1;
    protected int decryptBlockSize = -1;
    private AlgorithmParameterSpec algorithmParameterSpec;
    private SecureRandom random;

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, String privateKeyStr, String publicKeyStr) {
        this(algorithm.getValue(), SecureUtil.decode(privateKeyStr), SecureUtil.decode(publicKeyStr));
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(algorithm.getValue(), new KeyPair(publicKey, privateKey));
    }

    public AsymmetricCrypto(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm, Base64.decode(privateKeyBase64), Base64.decode(publicKeyBase64));
    }

    public AsymmetricCrypto(String algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm, new KeyPair(KeyUtil.generatePublicKey(algorithm, publicKey), KeyUtil.generatePrivateKey(algorithm, privateKey)));
    }

    public AsymmetricCrypto(String algorithm, KeyPair keyPair) {
        super(algorithm, keyPair);
    }

    public int getEncryptBlockSize() {
        return this.encryptBlockSize;
    }

    public void setEncryptBlockSize(int encryptBlockSize) {
        this.encryptBlockSize = encryptBlockSize;
    }

    public int getDecryptBlockSize() {
        return this.decryptBlockSize;
    }

    public void setDecryptBlockSize(int decryptBlockSize) {
        this.decryptBlockSize = decryptBlockSize;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    public AsymmetricCrypto setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this.algorithmParameterSpec = algorithmParameterSpec;
        return this;
    }

    public AsymmetricCrypto setRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    public AsymmetricCrypto init(String algorithm, KeyPair keyPair) {
        super.init(algorithm, keyPair);
        this.initCipher();
        return this;
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            int blockSize;
            Cipher cipher = this.initMode(CipherMode.ENCRYPT, key);
            if (this.encryptBlockSize < 0 && (blockSize = cipher.getBlockSize()) > 0) {
                this.encryptBlockSize = blockSize;
            }
            byte[] byArray = this.doFinal(data, this.encryptBlockSize < 0 ? data.length : this.encryptBlockSize);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] decrypt(byte[] data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            int blockSize;
            Cipher cipher = this.initMode(CipherMode.DECRYPT, key);
            if (this.decryptBlockSize < 0 && (blockSize = cipher.getBlockSize()) > 0) {
                this.decryptBlockSize = blockSize;
            }
            byte[] byArray = this.doFinal(data, this.decryptBlockSize < 0 ? data.length : this.decryptBlockSize);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    protected void initCipher() {
        this.cipher = new JceCipher(this.algorithm);
    }

    private byte[] doFinal(byte[] data, int maxBlockSize) throws IOException {
        if (data.length <= maxBlockSize) {
            return this.cipher.processFinal(data, 0, data.length);
        }
        return this.doFinalWithBlock(data, maxBlockSize);
    }

    private byte[] doFinalWithBlock(byte[] data, int maxBlockSize) throws IOException {
        int dataLength = data.length;
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        int offSet = 0;
        int remainLength = dataLength;
        while (remainLength > 0) {
            int blockSize = Math.min(remainLength, maxBlockSize);
            out.write(this.cipher.processFinal(data, offSet, blockSize));
            remainLength = dataLength - (offSet += blockSize);
        }
        return out.toByteArray();
    }

    private Cipher initMode(CipherMode mode, Key key) {
        Cipher cipher = this.cipher;
        cipher.init(mode, new JceCipher.JceParameters(key, this.algorithmParameterSpec, this.random));
        return cipher;
    }
}

